/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorArithmeticNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMVectorArithmeticNode.class)
public final class LLVMVectorArithmeticNodeGen
extends LLVMVectorArithmeticNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode leftNode_;
    @Node.Child
    private LLVMExpressionNode rightNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMVectorArithmeticNodeGen(int vectorLength, LLVMArithmeticNode arithmeticNode, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
        super(vectorLength, arithmeticNode);
        this.leftNode_ = leftNode;
        this.rightNode_ = rightNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }
        if ((state_0 & 0xFE) != 0) {
            LLVMVector leftNodeValue__;
            if ((state_0 & 2) != 0 && leftNodeValue_ instanceof LLVMI1Vector) {
                leftNodeValue__ = (LLVMI1Vector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector rightNodeValue__ = (LLVMI1Vector)rightNodeValue_;
                    return this.doI1((LLVMI1Vector)leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 4) != 0 && leftNodeValue_ instanceof LLVMI8Vector) {
                leftNodeValue__ = (LLVMI8Vector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightNodeValue__ = (LLVMI8Vector)rightNodeValue_;
                    return this.doI8((LLVMI8Vector)leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 8) != 0 && leftNodeValue_ instanceof LLVMI16Vector) {
                leftNodeValue__ = (LLVMI16Vector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightNodeValue__ = (LLVMI16Vector)rightNodeValue_;
                    return this.doI16((LLVMI16Vector)leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0x10) != 0 && leftNodeValue_ instanceof LLVMI32Vector) {
                leftNodeValue__ = (LLVMI32Vector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightNodeValue__ = (LLVMI32Vector)rightNodeValue_;
                    return this.doI32((LLVMI32Vector)leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0x20) != 0 && leftNodeValue_ instanceof LLVMI64Vector) {
                leftNodeValue__ = (LLVMI64Vector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightNodeValue__ = (LLVMI64Vector)rightNodeValue_;
                    return this.doI64((LLVMI64Vector)leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0x40) != 0 && leftNodeValue_ instanceof LLVMFloatVector) {
                leftNodeValue__ = (LLVMFloatVector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector rightNodeValue__ = (LLVMFloatVector)rightNodeValue_;
                    return this.doFloat((LLVMFloatVector)leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0x80) != 0 && leftNodeValue_ instanceof LLVMDoubleVector) {
                leftNodeValue__ = (LLVMDoubleVector)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightNodeValue__ = (LLVMDoubleVector)rightNodeValue_;
                    return this.doDouble((LLVMDoubleVector)leftNodeValue__, rightNodeValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private LLVMVector executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        LLVMVector leftNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (leftNodeValue instanceof LLVMI1Vector) {
            leftNodeValue_ = (LLVMI1Vector)leftNodeValue;
            if (rightNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector rightNodeValue_ = (LLVMI1Vector)rightNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1((LLVMI1Vector)leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI8Vector) {
            leftNodeValue_ = (LLVMI8Vector)leftNodeValue;
            if (rightNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector rightNodeValue_ = (LLVMI8Vector)rightNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8((LLVMI8Vector)leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI16Vector) {
            leftNodeValue_ = (LLVMI16Vector)leftNodeValue;
            if (rightNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector rightNodeValue_ = (LLVMI16Vector)rightNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16((LLVMI16Vector)leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI32Vector) {
            leftNodeValue_ = (LLVMI32Vector)leftNodeValue;
            if (rightNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector rightNodeValue_ = (LLVMI32Vector)rightNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32((LLVMI32Vector)leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI64Vector) {
            leftNodeValue_ = (LLVMI64Vector)leftNodeValue;
            if (rightNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector rightNodeValue_ = (LLVMI64Vector)rightNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64((LLVMI64Vector)leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMFloatVector) {
            leftNodeValue_ = (LLVMFloatVector)leftNodeValue;
            if (rightNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector rightNodeValue_ = (LLVMFloatVector)rightNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat((LLVMFloatVector)leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMDoubleVector) {
            leftNodeValue_ = (LLVMDoubleVector)leftNodeValue;
            if (rightNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector rightNodeValue_ = (LLVMDoubleVector)rightNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble((LLVMDoubleVector)leftNodeValue_, rightNodeValue_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        this.state_0_ |= 0x40;
        this.state_0_ |= 0x80;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMVectorArithmeticNode create(int vectorLength, LLVMArithmeticNode arithmeticNode, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
        return new LLVMVectorArithmeticNodeGen(vectorLength, arithmeticNode, leftNode, rightNode);
    }
}

