/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.literals;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMSimpleLiteralNode.class)
public final class LLVMSimpleLiteralNodeFactory {

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMNativePointerLiteralNode.class)
    public static final class LLVMNativePointerLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMNativePointerLiteralNode
    implements GenerateAOT.Provider {
        private LLVMNativePointerLiteralNodeGen(LLVMNativePointer address) {
            super(address);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doNativePointer();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMNativePointerLiteralNode create(LLVMNativePointer address) {
            return new LLVMNativePointerLiteralNodeGen(address);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMManagedPointerLiteralNode.class)
    public static final class LLVMManagedPointerLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMManagedPointerLiteralNode
    implements GenerateAOT.Provider {
        private LLVMManagedPointerLiteralNodeGen(LLVMManagedPointer address) {
            super(address);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doManagedPointer();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMManagedPointerLiteralNode create(LLVMManagedPointer address) {
            return new LLVMManagedPointerLiteralNodeGen(address);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVM128BitFloatLiteralNode.class)
    public static final class LLVM128BitFloatLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVM128BitFloatLiteralNode
    implements GenerateAOT.Provider {
        private LLVM128BitFloatLiteralNodeGen(LLVM128BitFloat literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.do80BitFloat();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVM128BitFloatLiteralNode create(LLVM128BitFloat literal) {
            return new LLVM128BitFloatLiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVM80BitFloatLiteralNode.class)
    public static final class LLVM80BitFloatLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVM80BitFloatLiteralNode
    implements GenerateAOT.Provider {
        private LLVM80BitFloatLiteralNodeGen(LLVM80BitFloat literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.do80BitFloat();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVM80BitFloatLiteralNode create(LLVM80BitFloat literal) {
            return new LLVM80BitFloatLiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMDoubleLiteralNode.class)
    public static final class LLVMDoubleLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMDoubleLiteralNode
    implements GenerateAOT.Provider {
        private LLVMDoubleLiteralNodeGen(double literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doDouble();
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            return this.doDouble();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMDoubleLiteralNode create(double literal) {
            return new LLVMDoubleLiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMFloatLiteralNode.class)
    public static final class LLVMFloatLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMFloatLiteralNode
    implements GenerateAOT.Provider {
        private LLVMFloatLiteralNodeGen(float literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return Float.valueOf(this.doFloat());
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            return this.doFloat();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMFloatLiteralNode create(float literal) {
            return new LLVMFloatLiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMI64LiteralNode.class)
    public static final class LLVMI64LiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMI64LiteralNode
    implements GenerateAOT.Provider {
        private LLVMI64LiteralNodeGen(long literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doI64();
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            return this.doI64();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMI64LiteralNode create(long literal) {
            return new LLVMI64LiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMI32LiteralNode.class)
    public static final class LLVMI32LiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMI32LiteralNode
    implements GenerateAOT.Provider {
        private LLVMI32LiteralNodeGen(int literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doI32();
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            return this.doI32();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMI32LiteralNode create(int literal) {
            return new LLVMI32LiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMI16LiteralNode.class)
    public static final class LLVMI16LiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMI16LiteralNode
    implements GenerateAOT.Provider {
        private LLVMI16LiteralNodeGen(short literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doI16();
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            return this.doI16();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMI16LiteralNode create(short literal) {
            return new LLVMI16LiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMI8LiteralNode.class)
    public static final class LLVMI8LiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMI8LiteralNode
    implements GenerateAOT.Provider {
        private LLVMI8LiteralNodeGen(byte literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doI8();
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            return this.doI8();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMI8LiteralNode create(byte literal) {
            return new LLVMI8LiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMI1LiteralNode.class)
    public static final class LLVMI1LiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMI1LiteralNode
    implements GenerateAOT.Provider {
        private LLVMI1LiteralNodeGen(boolean literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doI1();
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            return this.doI1();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMI1LiteralNode create(boolean literal) {
            return new LLVMI1LiteralNodeGen(literal);
        }
    }

    @GeneratedBy(value=LLVMSimpleLiteralNode.LLVMIVarBitLiteralNode.class)
    public static final class LLVMIVarBitLiteralNodeGen
    extends LLVMSimpleLiteralNode.LLVMIVarBitLiteralNode
    implements GenerateAOT.Provider {
        private LLVMIVarBitLiteralNodeGen(LLVMIVarBit literal) {
            super(literal);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doIVarBit();
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMSimpleLiteralNode.LLVMIVarBitLiteralNode create(LLVMIVarBit literal) {
            return new LLVMIVarBitLiteralNodeGen(literal);
        }
    }
}

