/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.literals;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMSimpleLiteralNode
extends LLVMExpressionNode {
    private LLVMSimpleLiteralNode() {
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getShortString(new String[0]) + " value=" + String.valueOf(this.executeGeneric(null));
    }

    public static abstract class LLVMNativePointerLiteralNode
    extends LLVMSimpleLiteralNode {
        private final long address;

        public LLVMNativePointerLiteralNode(LLVMNativePointer address) {
            this.address = address.asNative();
        }

        @Specialization
        public LLVMNativePointer doNativePointer() {
            return LLVMNativePointer.create(this.address);
        }
    }

    public static abstract class LLVMManagedPointerLiteralNode
    extends LLVMSimpleLiteralNode {
        private final LLVMManagedPointer address;

        public LLVMManagedPointerLiteralNode(LLVMManagedPointer address) {
            this.address = address;
        }

        @Override
        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            if (this.address.getObject() instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor function = (LLVMFunctionDescriptor)this.address.getObject();
                return this.getShortString(new String[0]) + " value=" + String.valueOf(this.address) + " function=\"" + function.getLLVMFunction().getName() + "\"";
            }
            return this.getShortString(new String[0]) + " value=" + String.valueOf(this.address);
        }

        @Specialization
        public LLVMManagedPointer doManagedPointer() {
            return this.address.copy();
        }

        public static LLVMManagedPointerLiteralNode create(LLVMManagedPointer pointer) {
            return LLVMSimpleLiteralNodeFactory.LLVMManagedPointerLiteralNodeGen.create(pointer);
        }
    }

    public static abstract class LLVM128BitFloatLiteralNode
    extends LLVMSimpleLiteralNode {
        private final long expSignFraction;
        private final long fraction;

        public LLVM128BitFloatLiteralNode(LLVM128BitFloat literal) {
            this.expSignFraction = literal.getExpSignFractionPart();
            this.fraction = literal.getSecondFractionPart();
        }

        @Specialization
        public LLVM128BitFloat do80BitFloat() {
            return new LLVM128BitFloat(this.expSignFraction, this.fraction);
        }
    }

    public static abstract class LLVM80BitFloatLiteralNode
    extends LLVMSimpleLiteralNode {
        private final short expSign;
        private final long fraction;

        public LLVM80BitFloatLiteralNode(LLVM80BitFloat literal) {
            this.expSign = literal.getExpSign();
            this.fraction = literal.getFraction();
        }

        @Specialization
        public LLVM80BitFloat do80BitFloat() {
            return new LLVM80BitFloat(this.expSign, this.fraction);
        }
    }

    public static abstract class LLVMDoubleLiteralNode
    extends LLVMSimpleLiteralNode {
        private final double literal;

        public LLVMDoubleLiteralNode(double literal) {
            this.literal = literal;
        }

        @Specialization
        public double doDouble() {
            return this.literal;
        }
    }

    public static abstract class LLVMFloatLiteralNode
    extends LLVMSimpleLiteralNode {
        private final float literal;

        public LLVMFloatLiteralNode(float literal) {
            this.literal = literal;
        }

        @Specialization
        public float doFloat() {
            return this.literal;
        }
    }

    public static abstract class LLVMI64LiteralNode
    extends LLVMSimpleLiteralNode {
        private final long literal;

        public LLVMI64LiteralNode(long literal) {
            this.literal = literal;
        }

        @Specialization
        public long doI64() {
            return this.literal;
        }
    }

    public static abstract class LLVMI32LiteralNode
    extends LLVMSimpleLiteralNode {
        private final int literal;

        public LLVMI32LiteralNode(int literal) {
            this.literal = literal;
        }

        @Specialization
        public int doI32() {
            return this.literal;
        }
    }

    public static abstract class LLVMI16LiteralNode
    extends LLVMSimpleLiteralNode {
        private final short literal;

        public LLVMI16LiteralNode(short literal) {
            this.literal = literal;
        }

        @Specialization
        public short doI16() {
            return this.literal;
        }
    }

    public static abstract class LLVMI8LiteralNode
    extends LLVMSimpleLiteralNode {
        private final byte literal;

        public LLVMI8LiteralNode(byte literal) {
            this.literal = literal;
        }

        @Specialization
        public byte doI8() {
            return this.literal;
        }
    }

    public static abstract class LLVMI1LiteralNode
    extends LLVMSimpleLiteralNode {
        private final boolean literal;

        public LLVMI1LiteralNode(boolean literal) {
            this.literal = literal;
        }

        @Specialization
        public boolean doI1() {
            return this.literal;
        }
    }

    public static abstract class LLVMIVarBitLiteralNode
    extends LLVMSimpleLiteralNode {
        private final LLVMIVarBit literal;

        public LLVMIVarBitLiteralNode(LLVMIVarBit literal) {
            this.literal = literal;
        }

        @Specialization
        public LLVMIVarBit doIVarBit() {
            return this.literal.copy();
        }
    }
}

