/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;

public final class LLVMDebugAggregateObjectBuilder
extends LLVMDebugObjectBuilder {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] offsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] lengths;
    private final LLVMDebugValue.Builder[] partBuilders;
    private final Object[] partValues;

    public LLVMDebugAggregateObjectBuilder(int[] offsets, int[] lengths) {
        this.offsets = offsets;
        this.lengths = lengths;
        this.partBuilders = new LLVMDebugValue.Builder[offsets.length];
        this.partValues = new Object[offsets.length];
    }

    public void setPart(int partIndex, LLVMDebugValue.Builder builder, Object value) {
        this.partBuilders[partIndex] = builder;
        this.partValues[partIndex] = value;
    }

    public void clear(int[] clearIndices) {
        for (int partIndex : clearIndices) {
            this.partValues[partIndex] = null;
            this.partBuilders[partIndex] = null;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMDebugObject getValue(LLVMSourceType type, LLVMSourceLocation declaration) {
        FragmentValueProvider provider = new FragmentValueProvider(this.offsets, this.lengths, this.partBuilders, this.partValues);
        return LLVMDebugObject.create(type, 0L, provider, declaration);
    }

    private static final class FragmentValueProvider
    implements LLVMDebugValue {
        private final int[] offsets;
        private final int[] lengths;
        private final LLVMDebugValue.Builder[] partBuilders;
        private final Object[] partValues;

        private FragmentValueProvider(int[] offsets, int[] lengths, LLVMDebugValue.Builder[] partBuilders, Object[] partValues) {
            this.offsets = offsets;
            this.lengths = lengths;
            this.partBuilders = partBuilders;
            this.partValues = partValues;
        }

        private LLVMDebugValue getProvider(long bitOffset, int bitSize) {
            int start = (int)bitOffset;
            int end = start + bitSize;
            int bestFitIndex = -1;
            int bestFitSlack = -1;
            for (int i = 0; i < this.offsets.length && this.offsets[i] <= start; ++i) {
                int newSlack;
                if (this.partValues[i] == null || end > this.offsets[i] + this.lengths[i] || (newSlack = this.getSlack(i, start, end)) >= bestFitSlack && bestFitSlack >= 0) continue;
                bestFitIndex = i;
                bestFitSlack = newSlack;
            }
            if (bestFitIndex >= 0) {
                LLVMDebugValue provider = this.partBuilders[bestFitIndex].build(this.partValues[bestFitIndex]);
                return new OffsetValueProvider(provider, this.offsets[bestFitIndex]);
            }
            return LLVMDebugValue.UNAVAILABLE;
        }

        private int getSlack(int partIndex, int start, int end) {
            int slack = start - this.offsets[partIndex];
            return slack += this.offsets[partIndex] + this.lengths[partIndex] - end;
        }

        @Override
        public String describeValue(long bitOffset, int bitSize) {
            return this.getProvider(bitOffset, bitSize).describeValue(bitOffset, bitSize);
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return this.getProvider(bitOffset, bits).canRead(bitOffset, bits);
        }

        @Override
        public Object readBoolean(long bitOffset) {
            return this.getProvider(bitOffset, 1).readBoolean(bitOffset);
        }

        @Override
        public Object readFloat(long bitOffset) {
            return this.getProvider(bitOffset, 32).readFloat(bitOffset);
        }

        @Override
        public Object readDouble(long bitOffset) {
            return this.getProvider(bitOffset, 64).readDouble(bitOffset);
        }

        @Override
        public Object read80BitFloat(long bitOffset) {
            return this.getProvider(bitOffset, 80).read80BitFloat(bitOffset);
        }

        @Override
        public Object readAddress(long bitOffset) {
            return this.getProvider(bitOffset, 64).readAddress(bitOffset);
        }

        @Override
        public Object readUnknown(long bitOffset, int bitSize) {
            return this.getProvider(bitOffset, bitSize).readUnknown(bitOffset, bitSize);
        }

        @Override
        public Object computeAddress(long bitOffset) {
            return this.getProvider(bitOffset, 0).computeAddress(bitOffset);
        }

        @Override
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            return this.getProvider(bitOffset, bitSize).readBigInteger(bitOffset, bitSize, signed);
        }

        @Override
        public LLVMDebugValue dereferencePointer(long bitOffset) {
            return this.getProvider(bitOffset, 64).dereferencePointer(bitOffset);
        }

        @Override
        public boolean isInteropValue() {
            return false;
        }

        @Override
        public Object asInteropValue() {
            return null;
        }
    }

    private static final class OffsetValueProvider
    implements LLVMDebugValue {
        private final LLVMDebugValue baseProvider;
        private final long offset;

        private OffsetValueProvider(LLVMDebugValue baseProvider, long offset) {
            this.baseProvider = baseProvider;
            this.offset = offset;
        }

        private long getOffset(long originalOffset) {
            return originalOffset - this.offset;
        }

        @Override
        public String describeValue(long bitOffset, int bitSize) {
            return this.baseProvider.describeValue(this.getOffset(bitOffset), bitSize);
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return this.baseProvider.canRead(this.getOffset(bitOffset), bits);
        }

        @Override
        public Object readBoolean(long bitOffset) {
            return this.baseProvider.readBoolean(this.getOffset(bitOffset));
        }

        @Override
        public Object readFloat(long bitOffset) {
            return this.baseProvider.readFloat(this.getOffset(bitOffset));
        }

        @Override
        public Object readDouble(long bitOffset) {
            return this.baseProvider.readDouble(this.getOffset(bitOffset));
        }

        @Override
        public Object read80BitFloat(long bitOffset) {
            return this.baseProvider.read80BitFloat(this.getOffset(bitOffset));
        }

        @Override
        public Object readAddress(long bitOffset) {
            return this.baseProvider.readAddress(this.getOffset(bitOffset));
        }

        @Override
        public Object readUnknown(long bitOffset, int bitSize) {
            return this.baseProvider.readUnknown(this.getOffset(bitOffset), bitSize);
        }

        @Override
        public Object computeAddress(long bitOffset) {
            return this.baseProvider.computeAddress(this.getOffset(bitOffset));
        }

        @Override
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            return this.baseProvider.readBigInteger(this.getOffset(bitOffset), bitSize, signed);
        }

        @Override
        public LLVMDebugValue dereferencePointer(long bitOffset) {
            return this.baseProvider.dereferencePointer(this.getOffset(bitOffset));
        }

        @Override
        public boolean isInteropValue() {
            return this.baseProvider.isInteropValue();
        }

        @Override
        public Object asInteropValue() {
            return this.baseProvider.asInteropValue();
        }
    }
}

