/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBConstant;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.math.BigInteger;

final class LLDBMemoryValue
implements LLVMDebugValue {
    private final LLVMPointer pointer;

    LLDBMemoryValue(LLVMPointer pointer) {
        this.pointer = pointer;
    }

    protected LLVMPointer getPointer() {
        return this.pointer;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String describeValue(long bitOffset, int bitSize) {
        Object value = LLDBSupport.toSizeString(bitSize);
        value = (String)value + " at ";
        value = (String)value + String.valueOf(this.computeAddress(bitOffset));
        return value;
    }

    @Override
    public boolean canRead(long bitOffset, int bits) {
        return !this.pointer.isNull() && !this.isInteropValue();
    }

    private Object loadValue(Type loadtype, int byteOffset) {
        LLVMPointer offsetPointer = this.pointer.increment(byteOffset);
        CallTarget loadFunction = LLVMLanguage.getLLDBLoadFunction(loadtype);
        return loadFunction.call(new Object[]{offsetPointer});
    }

    @Override
    public Object readBoolean(long bitOffset) {
        if (!this.canRead(bitOffset, 1)) {
            return this.unavailable(bitOffset, 1);
        }
        if (LLDBMemoryValue.isByteAligned(bitOffset)) {
            Object value = this.loadValue(PrimitiveType.I1, (int)(bitOffset / 8L));
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue() != 0L;
            }
            return this.unavailable(bitOffset, 1);
        }
        Object containingByte = this.loadValue(PrimitiveType.I8, (int)(bitOffset / 8L));
        if (containingByte instanceof Byte) {
            int shift = (int)bitOffset % 8;
            int shiftedByte = (Byte)containingByte >> shift;
            return (shiftedByte & 1) != 0;
        }
        return this.unavailable(bitOffset, 1);
    }

    @Override
    public Object readFloat(long bitOffset) {
        if (!this.canRead(bitOffset, 32)) {
            return this.unavailable(bitOffset, 32);
        }
        if (LLDBMemoryValue.isByteAligned(bitOffset)) {
            Object value = this.loadValue(PrimitiveType.FLOAT, (int)(bitOffset / 8L));
            if (value instanceof Float) {
                return value;
            }
            return this.unavailable(bitOffset, 32);
        }
        int alignedOffset = (int)(bitOffset / 8L);
        long bits = 0L;
        for (int i = 0; i < 5; ++i) {
            Object byteValue = this.loadValue(PrimitiveType.I8, alignedOffset + i);
            if (byteValue instanceof Byte) {
                long shiftedByte = (long)((Byte)byteValue).byteValue() << 8 * i;
                bits |= shiftedByte;
                continue;
            }
            return this.unavailable(bitOffset, 32);
        }
        int shift = (int)bitOffset % 8;
        long shiftedBits = bits >> shift;
        return Float.valueOf(Float.intBitsToFloat((int)(shiftedBits & 0xFFFFFFFFL)));
    }

    @Override
    public Object readDouble(long bitOffset) {
        if (!this.canRead(bitOffset, 64)) {
            return this.unavailable(bitOffset, 64);
        }
        if (LLDBMemoryValue.isByteAligned(bitOffset)) {
            Object value = this.loadValue(PrimitiveType.DOUBLE, (int)(bitOffset / 8L));
            if (value instanceof Double) {
                return value;
            }
            return this.unavailable(bitOffset, 64);
        }
        Object asBits = this.readBigInteger(bitOffset, 64, false);
        if (asBits instanceof BigInteger) {
            BigInteger bits = (BigInteger)asBits;
            return Double.longBitsToDouble(bits.longValue());
        }
        return this.unavailable(bitOffset, 64);
    }

    @Override
    public Object read80BitFloat(long bitOffset) {
        if (!this.canRead(bitOffset, 80)) {
            return this.unavailable(bitOffset, 80);
        }
        if (LLDBMemoryValue.isByteAligned(bitOffset)) {
            Object value = this.loadValue(PrimitiveType.X86_FP80, (int)(bitOffset / 8L));
            if (value instanceof LLVM80BitFloat) {
                return value;
            }
            return this.unavailable(bitOffset, 80);
        }
        Object asBits = this.readBigInteger(bitOffset, 80, false);
        if (asBits instanceof BigInteger) {
            BigInteger bits = (BigInteger)asBits;
            return LLVM80BitFloat.fromBytesBigEndian(bits.toByteArray());
        }
        return this.unavailable(bitOffset, 80);
    }

    @Override
    public Object readAddress(long bitOffset) {
        if (!this.canRead(bitOffset, 64)) {
            return this.unavailable(bitOffset, 64);
        }
        if (LLDBMemoryValue.isByteAligned(bitOffset)) {
            Object value = this.loadValue(PointerType.VOID, (int)(bitOffset / 8L));
            if (LLVMPointer.isInstance(value)) {
                return value;
            }
            if (value instanceof Number) {
                return LLVMNativePointer.create(((Number)value).longValue());
            }
            return this.unavailable(bitOffset, 64);
        }
        Object asBits = this.readBigInteger(bitOffset, 64, false);
        if (asBits instanceof BigInteger) {
            BigInteger bits = (BigInteger)asBits;
            return LLVMNativePointer.create(bits.longValue());
        }
        return this.unavailable(bitOffset, 64);
    }

    @Override
    public Object readUnknown(long bitOffset, int bitSize) {
        Object integerObject;
        if (this.canRead(bitOffset, bitSize) && (integerObject = this.readBigInteger(bitOffset, bitSize, false)) instanceof BigInteger) {
            return LLVMDebugValue.toHexString((BigInteger)integerObject);
        }
        return this.unavailable(bitOffset, bitSize);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object computeAddress(long bitOffset) {
        if (this.pointer.isNull()) {
            return this.pointer;
        }
        if (LLVMManagedPointer.isInstance(this.pointer)) {
            return "<managed value>" + (String)(bitOffset == 0L ? "" : " + " + LLDBSupport.toSizeString(bitOffset));
        }
        if (LLVMNativePointer.isInstance(this.pointer)) {
            LLVMNativePointer nativePointer = LLVMNativePointer.cast(this.pointer);
            long offset = bitOffset;
            if (bitOffset != 0L) {
                nativePointer = nativePointer.increment(offset / 8L);
                offset %= 8L;
            }
            return nativePointer.toString() + (String)(offset == 0L ? "" : " + " + LLDBSupport.toSizeString(offset));
        }
        throw new IllegalStateException("Unknown Pointer: " + String.valueOf(this.pointer));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
        BigInteger shiftedMemory;
        if (!this.canRead(bitOffset, bitSize)) {
            return this.unavailable(bitOffset, bitSize);
        }
        int byteOffset = (int)(bitOffset / 8L);
        if (LLDBMemoryValue.isByteAligned(bitOffset)) {
            switch (bitSize) {
                case 8: {
                    Object value = this.loadValue(PrimitiveType.I8, byteOffset);
                    if (value instanceof Byte) {
                        return BigInteger.valueOf(signed ? (long)((Byte)value).byteValue() : (long)Byte.toUnsignedInt((Byte)value));
                    }
                    return this.unavailable(bitOffset, 8);
                }
                case 16: {
                    Object value = this.loadValue(PrimitiveType.I16, byteOffset);
                    if (value instanceof Short) {
                        return BigInteger.valueOf(signed ? (long)((Short)value).shortValue() : (long)Short.toUnsignedInt((Short)value));
                    }
                    return this.unavailable(bitOffset, 16);
                }
                case 32: {
                    Object value = this.loadValue(PrimitiveType.I32, byteOffset);
                    if (value instanceof Integer) {
                        return BigInteger.valueOf(signed ? (long)((Integer)value).intValue() : Integer.toUnsignedLong((Integer)value));
                    }
                    return this.unavailable(bitOffset, 32);
                }
                case 64: {
                    long longValue;
                    Object value = this.loadValue(PrimitiveType.I64, byteOffset);
                    if (value instanceof Long) {
                        longValue = (Long)value;
                    } else if (LLVMNativePointer.isInstance(value)) {
                        longValue = LLVMNativePointer.cast(value).asNative();
                    } else {
                        if (LLVMManagedPointer.isInstance(value)) {
                            return "<managed pointer>";
                        }
                        return this.unavailable(bitOffset, 64);
                    }
                    return signed ? BigInteger.valueOf(longValue) : new BigInteger(Long.toUnsignedString(longValue));
                }
            }
        }
        int alignedBitSize = bitSize + (int)bitOffset % 8;
        int alignedByteSize = (alignedBitSize - 1) / 8 + 1;
        byte[] bytes = new byte[alignedByteSize];
        for (int i = 0; i < alignedByteSize; ++i) {
            Object value = this.loadValue(PrimitiveType.I8, byteOffset + i);
            if (!(value instanceof Byte)) {
                return this.unavailable(bitOffset, bitSize);
            }
            bytes[alignedByteSize - 1 - i] = (Byte)value;
        }
        if (LLDBMemoryValue.isAllZeros(bytes)) {
            return BigInteger.ZERO;
        }
        BigInteger totalMemory = new BigInteger(1, bytes);
        BigInteger maskedMemory = shiftedMemory = totalMemory.shiftRight((int)(bitOffset % 8L));
        for (int i = bitSize; i < shiftedMemory.bitLength(); ++i) {
            maskedMemory = maskedMemory.clearBit(i);
        }
        if (BigInteger.ZERO.equals(maskedMemory) || LLDBMemoryValue.isAllZeros(maskedMemory.toByteArray())) {
            return BigInteger.ZERO;
        }
        if (!signed || !maskedMemory.testBit(bitSize - 1)) {
            return maskedMemory;
        }
        BigInteger value = maskedMemory;
        for (int i = 0; i < bitSize; ++i) {
            value = value.flipBit(i);
        }
        value = value.add(BigInteger.ONE);
        value = value.negate();
        return value;
    }

    private static boolean isAllZeros(byte[] bytes) {
        for (byte b : bytes) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAlwaysSafeToDereference(long bitOffset) {
        if (bitOffset == 0L && LLDBSupport.isNestedManagedPointer(this.pointer)) {
            return true;
        }
        Object pointerRead = this.readAddress(bitOffset);
        if (LLVMManagedPointer.isInstance(pointerRead)) {
            return LLDBSupport.pointsToObjectAccess(LLVMManagedPointer.cast(pointerRead));
        }
        return LLVMPointer.isInstance(pointerRead) && LLVMPointer.cast(pointerRead).getExportType() != null;
    }

    @Override
    public LLVMDebugValue dereferencePointer(long bitOffset) {
        if (bitOffset == 0L && LLDBSupport.isNestedManagedPointer(this.pointer)) {
            return new LLDBConstant.Pointer(LLVMPointer.cast(LLVMManagedPointer.cast(this.pointer).getObject()));
        }
        if (!this.canRead(bitOffset, 64) || !LLDBMemoryValue.isByteAligned(bitOffset)) {
            return null;
        }
        Object pointerRead = this.readAddress(bitOffset);
        if (LLVMPointer.isInstance(pointerRead)) {
            return CommonNodeFactory.createDebugDeclarationBuilder().build(pointerRead);
        }
        return null;
    }

    @Override
    public boolean isInteropValue() {
        if (LLVMManagedPointer.isInstance(this.pointer)) {
            return !LLDBSupport.pointsToObjectAccess(LLVMManagedPointer.cast(this.pointer)) && !LLDBSupport.isNestedManagedPointer(this.pointer);
        }
        return false;
    }

    @Override
    public Object asInteropValue() {
        return LLVMManagedPointer.cast(this.pointer).getObject();
    }

    private static boolean isByteAligned(long offset) {
        return (offset & 7L) == 0L;
    }
}

