/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMTypeIDNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTypeIDNode
extends LLVMExpressionNode {
    @CompilerDirectives.CompilationFinal
    private LLVMInteropType cachedType;

    public static LLVMTypeIDNode create(LLVMExpressionNode child) {
        return LLVMTypeIDNodeGen.create(child);
    }

    protected final LLVMInteropType getType(LLVMPointer pointer) {
        LLVMContext context = this.getContext();
        if (this.cachedType == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            LLVMGlobal global = context.findGlobal(pointer);
            if (global == null) {
                return null;
            }
            this.cachedType = global.getInteropType(context);
        } else assert (context.findGlobal(pointer).getInteropType(context) == this.cachedType);
        return this.cachedType;
    }

    @Specialization
    LLVMInteropType doGlobal(LLVMPointer pointer, @Cached BranchProfile wrongType) {
        LLVMInteropType type = this.getType(pointer);
        if (type instanceof LLVMInteropType.Array) {
            return ((LLVMInteropType.Array)type).elementType;
        }
        wrongType.enter();
        return this.fallback(pointer);
    }

    @Fallback
    LLVMInteropType.Structured fallback(Object typeid) {
        throw new LLVMPolyglotException(this, "Couldn't find runtime type information. Make sure the LLVM bitcode is compiled with debug information (-g).");
    }
}

