/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotTimeZoneGetIdNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.time.ZoneId;

@NodeChild(value="zoneId", type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotTimeZoneGetIdNode
extends LLVMExpressionNode {
    @Specialization
    @GenerateAOT.Exclude
    public LLVMManagedPointer doForeign(LLVMManagedPointer object, @Cached LLVMAsForeignNode foreign, @Cached BranchProfile profile, @CachedLibrary(limit="3") InteropLibrary interop) {
        Object zone = foreign.execute(object);
        return this.doExecute(zone, profile, interop);
    }

    @Specialization
    @GenerateAOT.Exclude
    public LLVMManagedPointer doExecute(Object value, @Cached BranchProfile exception, @CachedLibrary(limit="3") InteropLibrary interop) {
        try {
            ZoneId zoneId = interop.asTimeZone(value);
            return LLVMManagedPointer.create(zoneId.getId());
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "The object is not a time zone.");
        }
    }

    public static LLVMPolyglotTimeZoneGetIdNode create(LLVMExpressionNode zoneId) {
        return LLVMPolyglotTimeZoneGetIdNodeGen.create(zoneId);
    }
}

