/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCleanupPadNodeGen;

@NodeField(name="exceptionSlot", type=int.class)
public abstract class LLVMCleanupPadNode
extends LLVMExpressionNode {
    abstract int getExceptionSlot();

    @Specialization
    long doCleanupPad(VirtualFrame frame) {
        LLVMStack stack = (LLVMStack)frame.getArguments()[0];
        LLVMUserException.LLVMUserExceptionWindows exception = (LLVMUserException.LLVMUserExceptionWindows)((Object)frame.getObject(this.getExceptionSlot()));
        ((LLVMLanguage.LLVMThreadLocalValue)this.getLanguage().contextThreadLocal.get()).pushException(exception);
        long oldStackPointer = stack.getStackPointer();
        stack.setStackPointer(exception.getStackPointer());
        return oldStackPointer;
    }

    public static LLVMCleanupPadNode create(int exceptionSlot) {
        return LLVMCleanupPadNodeGen.create(exceptionSlot);
    }
}

