/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMBitcodeLibraryFunctions;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.CatchPadEntryNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNodeWrapper;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;

@GenerateWrapper
public abstract class LLVMCatchSwitchNode
extends LLVMControlFlowNode {
    public static LLVMCatchSwitchNode create(int exceptionSlot, int[] targetBlocks, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
        return LLVMCatchSwitchNode.create(exceptionSlot, targetBlocks, -1, getStack, phiNodes);
    }

    public static LLVMCatchSwitchNode create(int exceptionSlot, int[] targetBlocks, int unwindBlock, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
        return LLVMCatchSwitchNodeFactory.LLVMCatchSwitchImplNodeGen.create(exceptionSlot, targetBlocks, unwindBlock, getStack, phiNodes);
    }

    public abstract Object executeCondition(VirtualFrame var1);

    public abstract boolean checkCase(VirtualFrame var1, int var2, Object var3);

    public abstract int getConditionalSuccessorCount();

    public abstract boolean hasDefaultBlock();

    public abstract void throwException(VirtualFrame var1);

    public abstract void setCatchPadEntryNode(CatchPadEntryNode var1);

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return new LLVMCatchSwitchNodeWrapper(this, probeNode);
    }

    public static CatchPadEntryNode createCatchPadEntryNode(LLVMExpressionNode catchType, int attributes, LLVMExpressionNode exceptionSlot, PointerType exceptionType) {
        return LLVMCatchSwitchNodeFactory.CatchPadEntryNodeGen.create(exceptionType, attributes, null, null, null, null, null, catchType, exceptionSlot);
    }

    public static abstract class LLVMCatchSwitchImpl
    extends LLVMCatchSwitchNode {
        @Node.Children
        private final LLVMStatementNode[] phiNodes;
        @Node.Child
        private LLVMExpressionNode getStack;
        @Node.Children
        private final CatchPadEntryNode[] conditions;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] targetBlocks;
        @CompilerDirectives.CompilationFinal
        private final int unwindBlock;
        @CompilerDirectives.CompilationFinal
        private final int exceptionSlot;
        private int nextNode = 0;

        protected LLVMCatchSwitchImpl(int exceptionSlot, int[] targetBlocks, int unwindBlock, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
            this.targetBlocks = targetBlocks;
            this.phiNodes = phiNodes;
            this.conditions = new CatchPadEntryNode[unwindBlock >= 0 ? targetBlocks.length - 1 : targetBlocks.length];
            this.unwindBlock = unwindBlock;
            this.getStack = getStack;
            this.exceptionSlot = exceptionSlot;
        }

        @Override
        public void setCatchPadEntryNode(CatchPadEntryNode node) {
            this.conditions[this.nextNode++] = node;
        }

        @Specialization
        public Object doCondition(VirtualFrame frame) {
            assert (this.nextNode == this.conditions.length);
            return frame.getObject(this.exceptionSlot);
        }

        @Override
        public void throwException(VirtualFrame frame) {
            throw (LLVMUserException)((Object)frame.getObject(this.exceptionSlot));
        }

        @Override
        public boolean hasDefaultBlock() {
            return this.unwindBlock >= 0;
        }

        @Override
        public int getConditionalSuccessorCount() {
            return this.conditions.length;
        }

        @Override
        public boolean checkCase(VirtualFrame frame, int i, Object value) {
            assert (value instanceof LLVMUserException.LLVMUserExceptionWindows);
            LLVMUserException.LLVMUserExceptionWindows exception = (LLVMUserException.LLVMUserExceptionWindows)((Object)value);
            LLVMStack stack = (LLVMStack)this.getStack.executeGeneric(frame);
            return this.conditions[i].execute(frame, stack, exception.getExceptionObject(), exception.getUnwindHeader(), exception.getImageBase(), exception.getStackPointer());
        }

        @Override
        public int getSuccessorCount() {
            return this.targetBlocks.length;
        }

        @Override
        public int[] getSuccessors() {
            return this.targetBlocks;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            return this.phiNodes[successorIndex];
        }
    }

    @GenerateWrapper
    @NodeChildren(value={@NodeChild(value="stack", type=LLVMExpressionNode.class), @NodeChild(value="thrownObject", type=LLVMExpressionNode.class), @NodeChild(value="throwInfo", type=LLVMExpressionNode.class), @NodeChild(value="imageBase", type=LLVMExpressionNode.class), @NodeChild(value="catchType", type=LLVMExpressionNode.class), @NodeChild(value="exceptionSlot", type=LLVMExpressionNode.class), @NodeChild(value="stackPointer", type=LLVMExpressionNode.class)})
    public static abstract class CatchPadEntryNode
    extends LLVMInstrumentableNode {
        protected final PointerType exceptionType;
        protected final int attributes;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongCanCatchWindowsNode canCatch;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongEHCopyWindowsNode ehCopy;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongCanCatchWindowsNode exceptionSlot;

        protected CatchPadEntryNode(PointerType exceptionType, int attributes) {
            this.exceptionType = exceptionType;
            this.attributes = attributes;
        }

        protected CatchPadEntryNode(CatchPadEntryNode node) {
            this(node.exceptionType, node.attributes);
        }

        abstract boolean execute(VirtualFrame var1, LLVMStack var2, LLVMPointer var3, LLVMPointer var4, LLVMPointer var5, long var6);

        public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
            return new CatchPadEntryNodeWrapper(this, this, probe);
        }

        public LLVMBitcodeLibraryFunctions.SulongCanCatchWindowsNode getCanCatch() {
            if (this.canCatch == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.canCatch = (LLVMBitcodeLibraryFunctions.SulongCanCatchWindowsNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongCanCatchWindowsNode(this.getContext()));
            }
            return this.canCatch;
        }

        public LLVMBitcodeLibraryFunctions.SulongEHCopyWindowsNode getEHCopy() {
            if (this.ehCopy == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ehCopy = (LLVMBitcodeLibraryFunctions.SulongEHCopyWindowsNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongEHCopyWindowsNode(this.getContext()));
            }
            return this.ehCopy;
        }

        public boolean isConstant() {
            return (this.attributes & 1) != 0;
        }

        public boolean isVolatile() {
            return (this.attributes & 2) != 0;
        }

        public boolean isUnaligned() {
            return (this.attributes & 4) != 0;
        }

        public boolean isReference() {
            return (this.attributes & 8) != 0;
        }

        @Specialization
        public boolean doExecute(LLVMStack stack, LLVMPointer thrownObject, LLVMPointer throwInfo, LLVMPointer imageBase, long stackPointer, LLVMPointer catchType, LLVMPointer exceptionOut) {
            LLVMPointer catchableType = null;
            if (catchType.isNull() || !(catchableType = this.getCanCatch().canCatch(stack, thrownObject, throwInfo, catchType, imageBase)).isNull()) {
                stack.setStackPointer(stackPointer);
                this.getEHCopy().copy(stack, thrownObject, catchableType, imageBase, exceptionOut, this.attributes);
                return true;
            }
            return false;
        }
    }
}

