/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNodeWrapper;

@GenerateWrapper
public abstract class LLVMBasicBlockNode
extends LLVMStatementNode {
    public static final int RETURN_FROM_FUNCTION = -1;
    private final int blockId;
    private final String blockName;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public int[] nullableBefore;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public int[] nullableAfter;

    public static LLVMBasicBlockNode createBasicBlockNode(LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
        return new InitializedBlockNode(statements, termInstruction, blockId, blockName);
    }

    public LLVMBasicBlockNode(int blockId, String blockName) {
        this.blockId = blockId;
        this.blockName = blockName;
    }

    protected LLVMBasicBlockNode(LLVMBasicBlockNode other) {
        this.blockId = other.blockId;
        this.blockName = other.blockName;
    }

    @Override
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return new LLVMBasicBlockNodeWrapper(this, this, probeNode);
    }

    public void setNullableFrameSlots(int[] nullableBefore, int[] nullableAfter) {
        this.nullableBefore = nullableBefore;
        this.nullableAfter = nullableAfter;
    }

    public abstract LLVMStatementNode[] getStatements();

    @Override
    public abstract void execute(VirtualFrame var1);

    public abstract LLVMControlFlowNode getTerminatingInstruction();

    public int getBlockId() {
        return this.blockId;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public abstract double getBranchProbability(int var1);

    public abstract void enterSuccessor(int var1);

    @Override
    public String toString() {
        return this.getShortString("blockId", "nullableBefore", "nullableAfter");
    }

    private static final class InitializedBlockNode
    extends LLVMBasicBlockNode
    implements GenerateAOT.Provider {
        private final BranchProfile controlFlowExceptionProfile = BranchProfile.create();
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private long[] successorExecutionCount;
        @Node.Children
        private final LLVMStatementNode[] statements;
        @Node.Child
        public LLVMControlFlowNode termInstruction;
        @CompilerDirectives.CompilationFinal
        private boolean aot;
        @CompilerDirectives.CompilationFinal
        private double aotBranchProbability;

        InitializedBlockNode(LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
            super(blockId, blockName);
            this.successorExecutionCount = termInstruction.getSuccessorCount() > 1 ? new long[termInstruction.getSuccessorCount()] : null;
            this.statements = statements;
            this.termInstruction = termInstruction;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            this.aot = true;
            this.aotBranchProbability = this.successorExecutionCount != null ? 1.0 / (double)this.successorExecutionCount.length : 1.0;
        }

        @Override
        public LLVMStatementNode[] getStatements() {
            return this.statements;
        }

        @Override
        @ExplodeLoop
        public void execute(VirtualFrame frame) {
            for (int i = 0; i < this.statements.length; ++i) {
                LLVMStatementNode statement = this.statements[i];
                try {
                    statement.execute(frame);
                    continue;
                }
                catch (ControlFlowException e) {
                    this.controlFlowExceptionProfile.enter();
                    throw e;
                }
            }
        }

        @Override
        public LLVMControlFlowNode getTerminatingInstruction() {
            return this.termInstruction;
        }

        @Override
        @ExplodeLoop
        public double getBranchProbability(int successorIndex) {
            double successorBranchProbability;
            if (this.aot) {
                return this.aotBranchProbability;
            }
            if (this.successorExecutionCount == null) {
                return 1.0;
            }
            long succCount = 0L;
            long totalExecutionCount = 0L;
            for (int i = 0; i < this.successorExecutionCount.length; ++i) {
                long v = this.successorExecutionCount[i];
                if (successorIndex == i) {
                    succCount = v;
                }
                totalExecutionCount += v;
            }
            if (succCount == 0L) {
                successorBranchProbability = 0.0;
            } else {
                assert (totalExecutionCount > 0L);
                successorBranchProbability = (double)succCount / (double)totalExecutionCount;
            }
            assert (!Double.isNaN(successorBranchProbability) && successorBranchProbability >= 0.0 && successorBranchProbability <= 1.0);
            return successorBranchProbability;
        }

        @Override
        public void enterSuccessor(int successorIndex) {
            if (!this.aot && CompilerDirectives.inCompiledCode() && this.successorExecutionCount != null && this.successorExecutionCount[successorIndex] == 0L) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (CompilerDirectives.inInterpreter()) {
                if (this.aot) {
                    this.aot = false;
                }
                if (this.successorExecutionCount != null) {
                    int n = successorIndex;
                    this.successorExecutionCount[n] = this.successorExecutionCount[n] + 1L;
                }
            }
        }
    }
}

