/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMGetStackFromThreadNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMNativeWrapper
implements TruffleObject {
    final LLVMFunctionCode code;

    public LLVMNativeWrapper(LLVMFunctionCode code) {
        assert (code.isLLVMIRFunction() || code.isIntrinsicFunctionSlowPath());
        this.code = code;
    }

    public String toString() {
        return this.code.getLLVMFunction().toString();
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ImportStatic(value={LLVMLanguage.class})
    static abstract class CallbackHelperNode
    extends LLVMNode {
        final LLVMNativeWrapper wrapper;

        CallbackHelperNode(LLVMNativeWrapper wrapper) {
            this.wrapper = wrapper;
        }

        abstract Object execute(Object[] var1);

        @Specialization
        Object doCached(Object[] args, @Cached LLVMGetStackFromThreadNode getStack, @Cached(value="createCallNode()") DirectCallNode call, @Cached(value="createFromNativeNodes()") LLVMNativeConvertNode[] convertArgs, @Cached(value="createToNative(wrapper.code.getLLVMFunction().getType().getReturnType())") LLVMNativeConvertNode convertRet) {
            LLVMStack stack = getStack.executeWithTarget(this.getContext().getThreadingStack(), Thread.currentThread());
            Object[] preparedArgs = CallbackHelperNode.prepareCallbackArguments(stack, args, convertArgs);
            Object ret = call.call(preparedArgs);
            return convertRet.executeConvert(ret);
        }

        DirectCallNode createCallNode() {
            RootCallTarget callTarget;
            LLVMFunctionCode functionCode = this.wrapper.code;
            if (functionCode.isLLVMIRFunction()) {
                callTarget = functionCode.getLLVMIRFunctionSlowPath();
            } else if (functionCode.isIntrinsicFunctionSlowPath()) {
                callTarget = functionCode.getIntrinsicSlowPath().cachedCallTarget(functionCode.getLLVMFunction().getType());
            } else {
                throw new IllegalStateException("unexpected function: " + functionCode.getLLVMFunction().toString());
            }
            return DirectCallNode.create((CallTarget)callTarget);
        }

        protected LLVMNativeConvertNode[] createFromNativeNodes() {
            FunctionType type = this.wrapper.code.getLLVMFunction().getType();
            LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[type.getNumberOfArguments()];
            for (int i = 0; i < type.getNumberOfArguments(); ++i) {
                ret[i] = LLVMNativeConvertNode.createFromNative(type.getArgumentType(i));
            }
            return ret;
        }

        @ExplodeLoop
        private static Object[] prepareCallbackArguments(LLVMStack stack, Object[] arguments, LLVMNativeConvertNode[] fromNative) {
            Object[] callbackArgs = new Object[fromNative.length + 1];
            callbackArgs[0] = stack;
            for (int i = 0; i < fromNative.length; ++i) {
                callbackArgs[i + 1] = fromNative[i].executeConvert(arguments[i]);
            }
            return callbackArgs;
        }
    }

    @ExportMessage
    static final class Execute {
        Execute() {
        }

        @Specialization(limit="1", guards={"wrapper == callbackHelper.wrapper"})
        static Object doExecute(LLVMNativeWrapper wrapper, Object[] args, @Cached(value="create(wrapper)") CallbackHelperNode callbackHelper) {
            assert (wrapper == callbackHelper.wrapper);
            return callbackHelper.execute(args);
        }

        @Specialization(replaces={"doExecute"})
        static Object doError(LLVMNativeWrapper wrapper, Object[] args) {
            throw CompilerDirectives.shouldNotReachHere((String)"unexpected generic case in LLVMNativeWrapper");
        }
    }
}

