/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.nfi.api.SerializableLibrary;

@GenerateUncached
public abstract class ToFP80
extends ForeignToLLVM {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    @Specialization
    protected LLVM80BitFloat fromInt(int value) {
        return LLVM80BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM80BitFloat fromChar(char value) {
        return LLVM80BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM80BitFloat fromLong(long value) {
        return LLVM80BitFloat.fromLong(value);
    }

    @Specialization
    protected LLVM80BitFloat fromByte(byte value) {
        return LLVM80BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM80BitFloat fromShort(short value) {
        return LLVM80BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM80BitFloat fromFloat(float value) {
        return LLVM80BitFloat.fromFloat(value);
    }

    @Specialization
    protected LLVM80BitFloat fromDouble(double value) {
        return LLVM80BitFloat.fromDouble(value);
    }

    @Specialization(limit="1", guards={"serialize.isSerializable(value)"})
    protected LLVM80BitFloat from80BitFloat(Object value, @CachedLibrary(value="value") SerializableLibrary serialize) {
        try {
            byte[] buffer = new byte[10];
            LLVMManagedPointer ptr = LLVMManagedPointer.create(buffer).export(new LLVMInteropType.Buffer(true, 10L));
            serialize.serialize(value, (Object)ptr);
            return LLVM80BitFloat.fromBytes(buffer);
        }
        catch (UnsupportedMessageException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
        }
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "interop.isNumber(foreigns.asForeign(obj))"})
    @GenerateAOT.Exclude
    protected LLVM80BitFloat fromForeign(Object obj, @CachedLibrary(value="obj") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            Object foreign = foreigns.asForeign(obj);
            if (interop.fitsInLong(foreign)) {
                return LLVM80BitFloat.fromLong(interop.asLong(foreign));
            }
            if (interop.fitsInDouble(foreign)) {
                return LLVM80BitFloat.fromDouble(interop.asDouble(foreign));
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        exception.enter();
        throw new LLVMPolyglotException(this, "Polyglot number can't be converted to double.");
    }

    @CompilerDirectives.TruffleBoundary
    static LLVM80BitFloat slowPathPrimitiveConvert(Object value) throws UnsupportedTypeException {
        try {
            if (INTEROP.fitsInLong(value)) {
                return LLVM80BitFloat.fromLong(INTEROP.asLong(value));
            }
            if (INTEROP.fitsInDouble(value)) {
                return LLVM80BitFloat.fromDouble(INTEROP.asDouble(value));
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        throw UnsupportedTypeException.create((Object[])new Object[]{value});
    }
}

