/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropSpecialAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class LLVMInteropReadNode
extends LLVMNode {
    public static LLVMInteropReadNode create() {
        return LLVMInteropReadNodeGen.create();
    }

    public abstract Object execute(LLVMInteropType.Structured var1, Object var2, long var3, ForeignToLLVM.ForeignToLLVMType var5);

    static boolean hasVirtualMethods(LLVMInteropType.Structured type) {
        if (type instanceof LLVMInteropType.Clazz) {
            return ((LLVMInteropType.Clazz)type).hasVirtualMethods();
        }
        return false;
    }

    @Specialization(guards={"type == cachedType", "offset == 0", "cachedType != null", "cachedType.hasVirtualMethods()"})
    Object doClazzCached(LLVMInteropType.Clazz type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @Cached(value="type") LLVMInteropType.Clazz cachedType, @Cached(value="cachedType.getVTable()") LLVMInteropType.VTable vTable) {
        LLVMInteropType.VTableObjectPair vTableObjectPair = LLVMInteropType.VTableObjectPair.create(vTable, foreign);
        LLVMManagedPointer pointer = LLVMManagedPointer.create(vTableObjectPair);
        return pointer;
    }

    @Specialization(guards={"type != null", "hasVirtualMethods(type)", "offset == 0"}, replaces={"doClazzCached"})
    Object doClazz(LLVMInteropType.Clazz type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @Cached LLVMInteropAccessNode access, @Cached ReadLocationNode read) {
        if (type.hasVirtualMethods() && offset == 0L) {
            LLVMInteropType.VTableObjectPair vTableObjectPair = LLVMInteropType.VTableObjectPair.create(type.getVTable(), foreign);
            LLVMManagedPointer pointer = LLVMManagedPointer.create(vTableObjectPair);
            return pointer;
        }
        LLVMInteropAccessNode.AccessLocation location = access.execute(type, foreign, offset);
        return read.execute(location.identifier, location, accessType);
    }

    @Specialization(guards={"type != null"})
    Object doSpecialType(LLVMInteropType.SpecialStruct type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @Cached LLVMInteropSpecialAccessNode access) {
        return access.execute(foreign, accessType, type, offset);
    }

    @Specialization(guards={"type != null", "offset != 0 || !hasVirtualMethods(type)"})
    Object doKnownType(LLVMInteropType.Structured type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @Cached LLVMInteropAccessNode access, @Cached ReadLocationNode read) {
        LLVMInteropAccessNode.AccessLocation location = access.execute(type, foreign, offset);
        return read.execute(location.identifier, location, accessType);
    }

    @Specialization(guards={"type == null"})
    Object doUnknownType(LLVMInteropType.Structured type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @Cached ReadLocationNode read) {
        LLVMInteropAccessNode.AccessLocation location = new LLVMInteropAccessNode.AccessLocation(foreign, Long.divideUnsigned(offset, accessType.getSizeInBytes()), null);
        return read.execute(location.identifier, location, accessType);
    }

    @GenerateUncached
    static abstract class ReadLocationNode
    extends LLVMNode {
        ReadLocationNode() {
        }

        abstract Object execute(Object var1, LLVMInteropAccessNode.AccessLocation var2, ForeignToLLVM.ForeignToLLVMType var3);

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        Object readMember(String name, LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType, @CachedLibrary(value="location.base") InteropLibrary interop, @Cached ToLLVM toLLVM, @Cached BranchProfile exception) {
            assert (name == location.identifier);
            try {
                Object ret = interop.readMember(location.base, name);
                return toLLVM.executeWithType(ret, location.type, accessType);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Member '%s' not found", name);
            }
            catch (UnknownIdentifierException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Cannot read member '%s'", name);
            }
        }

        @Specialization(guards={"isLocationTypeNullOrSameSize(location, accessType)"}, limit="3")
        @GenerateAOT.Exclude
        Object readArrayElementTypeMatch(long identifier, LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType, @CachedLibrary(value="location.base") InteropLibrary interop, @Cached ToLLVM toLLVM, @Cached BranchProfile exception) {
            assert (identifier == (Long)location.identifier);
            long idx = identifier;
            try {
                Object ret = interop.readArrayElement(location.base, idx);
                return toLLVM.executeWithType(ret, location.type, accessType);
            }
            catch (InvalidArrayIndexException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Invalid array index %d", idx);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Cannot read array element %d", idx);
            }
        }

        @Specialization(guards={"!isLocationTypeNullOrSameSize(location, accessType)", "locationType.isI8()", "accessTypeSizeInBytes > 1"}, limit="3")
        @GenerateAOT.Exclude
        Object readArrayElementFromI8(long identifier, LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType, @CachedLibrary(value="location.base") InteropLibrary interop, @Cached ToLLVM toLLVM, @Cached ReinterpretLongAsLLVM fromLongToLLVM, @Cached BranchProfile exception, @Cached BranchProfile outOfBounds, @Bind(value="location.type.kind.foreignToLLVMType") ForeignToLLVM.ForeignToLLVMType locationType, @Bind(value="accessType.getSizeInBytes()") int accessTypeSizeInBytes) {
            assert (identifier == (Long)location.identifier);
            long idx = identifier;
            assert (locationType == ForeignToLLVM.ForeignToLLVMType.I8);
            long res = 0L;
            try {
                int i = 0;
                while (i < accessTypeSizeInBytes) {
                    Object ret = interop.readArrayElement(location.base, idx);
                    Object toLLVMValue = toLLVM.executeWithType(ret, LLVMInteropType.ValueKind.I8.type, LLVMInteropType.ValueKind.I8.foreignToLLVMType);
                    res |= Byte.toUnsignedLong((Byte)toLLVMValue) << 8 * i;
                    ++i;
                    ++idx;
                }
                return fromLongToLLVM.executeWithAccessType(res, accessType);
            }
            catch (InvalidArrayIndexException ex) {
                if (idx != identifier) {
                    outOfBounds.enter();
                    return fromLongToLLVM.executeWithAccessType(res, accessType);
                }
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Invalid array index %d", idx);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Cannot read array element %d", idx);
            }
        }

        static boolean isLocationTypeNullOrSameSize(LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType) {
            return location.type == null || location.type.kind.foreignToLLVMType.getSizeInBytes() == accessType.getSizeInBytes();
        }

        @Fallback
        Object fallback(Object identifier, LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType) {
            assert (location.type != null);
            throw new LLVMPolyglotException((Node)this, "Cannot read %d byte(s) from foreign object of element size %d", accessType.getSizeInBytes(), location.type.kind.foreignToLLVMType.getSizeInBytes());
        }
    }

    @GenerateUncached
    static abstract class ReinterpretLongAsLLVM
    extends LLVMNode {
        ReinterpretLongAsLLVM() {
        }

        abstract Object executeWithAccessType(long var1, ForeignToLLVM.ForeignToLLVMType var3);

        @Specialization(guards={"accessType.isI16()"})
        short toI16(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            return (short)value;
        }

        @Specialization(guards={"accessType.isI32()"})
        int toI32(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            return (int)value;
        }

        @Specialization(guards={"accessType.isI64()"})
        long toI64(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            return value;
        }

        @Specialization(guards={"accessType.isFloat()"})
        float toFloat(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            return Float.intBitsToFloat((int)value);
        }

        @Specialization(guards={"accessType.isDouble()"})
        double toDouble(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            return Double.longBitsToDouble(value);
        }

        @Specialization(guards={"accessType.isPointer()"})
        Object toPointer(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            return LLVMNativePointer.create(value);
        }

        @Fallback
        Object fallback(long value, ForeignToLLVM.ForeignToLLVMType accessType) {
            throw new LLVMPolyglotException((Node)this, "Unexpected access type %s", new Object[]{accessType});
        }
    }
}

