/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class LLVMSourceStructLikeType
extends LLVMSourceType {
    protected final List<LLVMSourceMemberType> dynamicMembers;
    protected final LLVMSourceStaticMemberType.CollectionType staticMembers;

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceStructLikeType(String name, long size, long align, long offset, LLVMSourceLocation location) {
        super(() -> name, size, align, offset, location);
        this.dynamicMembers = new ArrayList<LLVMSourceMemberType>();
        this.staticMembers = new LLVMSourceStaticMemberType.CollectionType();
    }

    protected LLVMSourceStructLikeType(Supplier<String> name, long size, long align, long offset, List<LLVMSourceMemberType> dynamicMembers, LLVMSourceStaticMemberType.CollectionType staticMembers, LLVMSourceLocation location) {
        super(name, size, align, offset, location);
        this.dynamicMembers = dynamicMembers;
        this.staticMembers = staticMembers;
    }

    @CompilerDirectives.TruffleBoundary
    public void addDynamicMember(LLVMSourceMemberType member) {
        CompilerAsserts.neverPartOfCompilation();
        this.dynamicMembers.add(member);
    }

    public void addStaticMember(LLVMSourceStaticMemberType member) {
        CompilerAsserts.neverPartOfCompilation();
        this.staticMembers.addMember(member);
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return new LLVMSourceStructLikeType(this::getName, this.getSize(), this.getAlign(), newOffset, this.dynamicMembers, this.staticMembers, this.getLocation());
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    public int getDynamicElementCount() {
        return this.dynamicMembers.size();
    }

    public LLVMSourceMemberType getDynamicElement(int i) {
        return this.dynamicMembers.get(i);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getElementCount() {
        int elementCount = this.dynamicMembers.size();
        if (this.staticMembers.getElementCount() != 0) {
            ++elementCount;
        }
        return elementCount;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getElementName(long i) {
        int index = (int)i;
        if (this.staticMembers.getElementCount() != 0) {
            if (index == 0) {
                return "<static>";
            }
            --index;
        }
        if (0 <= index && index < this.dynamicMembers.size()) {
            return this.dynamicMembers.get(index).getName();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public String getElementNameByOffset(long offset) {
        for (LLVMSourceMemberType member : this.dynamicMembers) {
            if (member.getOffset() != offset) continue;
            return member.getName();
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceType getElementType(long i) {
        int index = (int)i;
        if (this.staticMembers.getElementCount() != 0) {
            if (index == 0) {
                return this.staticMembers;
            }
            --index;
        }
        if (0 <= index && index < this.dynamicMembers.size()) {
            return this.dynamicMembers.get(index).getOffsetElementType();
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceType getElementType(String name) {
        if (name == null) {
            return null;
        }
        for (LLVMSourceMemberType member : this.dynamicMembers) {
            if (!name.equals(member.getName())) continue;
            return member.getOffsetElementType();
        }
        if ("<static>".equals(name)) {
            return this.staticMembers;
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceLocation getElementDeclaration(long i) {
        int index = (int)i;
        if (this.staticMembers.getElementCount() != 0) {
            if (index == 0) {
                return this.staticMembers.getLocation();
            }
            --index;
        }
        if (0 <= index && index < this.dynamicMembers.size()) {
            return this.dynamicMembers.get(index).getLocation();
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceLocation getElementDeclaration(String name) {
        if (name == null) {
            return null;
        }
        for (LLVMSourceMemberType member : this.dynamicMembers) {
            if (!name.equals(member.getName())) continue;
            return member.getLocation();
        }
        if ("<static>".equals(name)) {
            return this.staticMembers.getLocation();
        }
        return null;
    }
}

