/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;

public class LLVMSourceMemberType
extends LLVMSourceType {
    @CompilerDirectives.CompilationFinal
    private LLVMSourceType elementType;

    public LLVMSourceMemberType(String name, long size, long align, long offset, LLVMSourceLocation location) {
        this(name, size, align, offset, LLVMSourceType.UNKNOWN, location);
    }

    protected LLVMSourceMemberType(String name, long size, long align, long offset, LLVMSourceType elementType, LLVMSourceLocation location) {
        super(() -> name, size, align, offset, location);
        this.elementType = elementType;
    }

    public LLVMSourceType getElementType() {
        return this.elementType;
    }

    public void setElementType(LLVMSourceType elementType) {
        CompilerAsserts.neverPartOfCompilation();
        this.elementType = elementType;
    }

    LLVMSourceType getOffsetElementType() {
        return this.elementType != null ? this.elementType.getOffset(this.getOffset()) : null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("%s: %s", this.getName(), this.elementType != null ? this.elementType.getName() : null);
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return this;
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public int getElementCount() {
        return 1;
    }

    @Override
    public String getElementName(long i) {
        if (i == 0L) {
            return this.getName();
        }
        return null;
    }

    @Override
    public LLVMSourceType getElementType(long i) {
        if (i == 0L) {
            return this.getOffsetElementType();
        }
        return null;
    }

    @Override
    public LLVMSourceType getElementType(String name) {
        if (name != null && name.equals(this.getName())) {
            return this.getOffsetElementType();
        }
        return null;
    }
}

