/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.scope;

import java.util.Objects;
import org.graalvm.collections.Equivalence;

public interface LLVMSourceFileReference {
    public static final Equivalence EQUIVALENCE = new Equivalence(){

        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (!(a instanceof LLVMSourceFileReference)) {
                throw new IllegalArgumentException("Not applicable: " + String.valueOf(a.getClass()));
            }
            if (!(b instanceof LLVMSourceFileReference)) {
                throw new IllegalArgumentException("Not applicable: " + String.valueOf(b.getClass()));
            }
            LLVMSourceFileReference srcA = (LLVMSourceFileReference)a;
            LLVMSourceFileReference srcB = (LLVMSourceFileReference)b;
            return srcA.getChecksumKind() == srcB.getChecksumKind() && this.stringEquals(srcA.getFilename(), srcB.getFilename()) && this.stringEquals(srcA.getDirectory(), srcB.getDirectory()) && this.stringEquals(srcA.getChecksum(), srcB.getChecksum());
        }

        private boolean stringEquals(String a, String b) {
            return Objects.equals(a, b) || this.isEmpty(a) && this.isEmpty(b);
        }

        private boolean isEmpty(String s) {
            return s == null || "".equals(s);
        }

        public int hashCode(Object o) {
            if (o instanceof LLVMSourceFileReference) {
                LLVMSourceFileReference src = (LLVMSourceFileReference)o;
                return Objects.hash(new Object[]{src.getFilename(), src.getDirectory(), src.getChecksumKind(), src.getChecksum()});
            }
            throw new IllegalArgumentException("Not applicable: " + String.valueOf(o.getClass()));
        }
    };

    public String getFilename();

    public String getDirectory();

    public ChecksumKind getChecksumKind();

    public String getChecksum();

    public static LLVMSourceFileReference create(String filename, String directory, String checksumKind, String checksum) {
        return new LLVMSourceFileReferenceImpl(filename, directory, ChecksumKind.forName(checksumKind), checksum);
    }

    public static String toString(LLVMSourceFileReference o) {
        return "DIFile(filename='" + o.getFilename() + "', directory='" + o.getDirectory() + "', checksumKind=" + String.valueOf((Object)o.getChecksumKind()) + ", checksum='" + o.getChecksum() + "')";
    }

    public static final class LLVMSourceFileReferenceImpl
    implements LLVMSourceFileReference {
        private final String filename;
        private final String directory;
        private final ChecksumKind checksumKind;
        private final String checksum;

        LLVMSourceFileReferenceImpl(String filename, String directory, ChecksumKind checksumKind, String checksum) {
            this.filename = filename;
            this.directory = directory;
            this.checksumKind = checksumKind;
            this.checksum = checksum;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public String getDirectory() {
            return this.directory;
        }

        @Override
        public ChecksumKind getChecksumKind() {
            return this.checksumKind;
        }

        @Override
        public String getChecksum() {
            return this.checksum;
        }
    }

    public static enum ChecksumKind {
        CSK_None,
        CSK_MD5,
        CSK_SHA1,
        CSK_SHA256;


        public static ChecksumKind forBitcodeValue(int value) {
            switch (value) {
                case 1: {
                    return CSK_MD5;
                }
                case 2: {
                    return CSK_SHA1;
                }
                case 3: {
                    return CSK_SHA256;
                }
            }
            return CSK_None;
        }

        static ChecksumKind forName(String name) {
            try {
                return ChecksumKind.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return CSK_None;
            }
        }
    }
}

