/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class IDGenerater {
    private final AtomicInteger nextID = new AtomicInteger(0);
    private final ReferenceQueue<BitcodeID> refQueue = new ReferenceQueue();
    private final IDReference first = new IDReference();
    public static final BitcodeID INVALID_ID = new BitcodeID(-1, "");

    private synchronized void add(IDReference allocation) {
        assert (allocation.prev == null && allocation.next == null);
        IDReference second = this.first.next;
        allocation.prev = this.first;
        allocation.next = second;
        this.first.next = allocation;
        second.prev = allocation;
    }

    private static synchronized void remove(IDReference allocation) {
        allocation.prev.next = allocation.next;
        allocation.next.prev = allocation.prev;
        allocation.next = null;
        allocation.prev = null;
    }

    public BitcodeID generateID(String name) {
        IDReference ref = (IDReference)this.refQueue.poll();
        if (ref != null) {
            IDGenerater.remove(ref);
            return this.createID(ref.id, name);
        }
        return this.createID(this.nextID.getAndIncrement(), name);
    }

    private BitcodeID createID(int id, String name) {
        BitcodeID bitcodeID = new BitcodeID(id, name);
        IDReference ref = new IDReference(bitcodeID);
        this.add(ref);
        return bitcodeID;
    }

    private final class IDReference
    extends PhantomReference<BitcodeID> {
        private IDReference prev;
        private IDReference next;
        private final int id;

        private IDReference(BitcodeID id) {
            super(id, IDGenerater.this.refQueue);
            this.id = id.id;
        }

        private IDReference() {
            super(null, null);
            this.prev = this;
            this.next = this;
            this.id = -1;
        }
    }

    public static final class BitcodeID {
        private final int id;
        private final String name;

        private BitcodeID(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean same(BitcodeID other) {
            return this.id == other.getId();
        }
    }
}

