/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.globals;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.parser.model.enums.Visibility;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.PointerType;

public final class GlobalVariable
extends GlobalValueSymbol {
    private final boolean isReadOnly;
    private final int align;
    private final String sectionName;
    private final boolean isThreadLocal;

    private GlobalVariable(boolean isReadOnly, PointerType type, int align, String sectionName, Linkage linkage, Visibility visibility, boolean threadLocal, SymbolTable symbolTable, int value, int index) {
        super(type, linkage, visibility, symbolTable, value, index);
        this.isReadOnly = isReadOnly;
        this.align = align;
        this.isThreadLocal = threadLocal;
        this.sectionName = sectionName;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public int getAlign() {
        return this.align;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public static GlobalVariable create(boolean isReadOnly, PointerType type, int align, String sectionName, long linkage, long visibility, long threadLocal, SymbolTable symbolTable, int value, int index) {
        return new GlobalVariable(isReadOnly, type, align, sectionName, Linkage.decode(linkage), Visibility.decode(visibility), threadLocal > 0L, symbolTable, value, index);
    }

    public boolean isThreadLocal() {
        return this.isThreadLocal;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMSymbol symbol = runtime.lookupSymbol(this.getName());
        if (symbol.isGlobalVariable()) {
            symbol = symbol.asGlobalVariable();
        } else if (symbol.isThreadLocalSymbol()) {
            symbol = symbol.asThreadLocalSymbol();
        } else {
            throw new AssertionError(symbol.getClass());
        }
        return CommonNodeFactory.createLiteral(symbol, new PointerType(this.getType()));
    }
}

