/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.AggregateConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.VectorType;

public final class VectorConstant
extends AggregateConstant {
    VectorConstant(VectorType type, int elemCount) {
        super(type, elemCount);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return String.format("<%s>", super.toString());
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMExpressionNode[] values = new LLVMExpressionNode[this.getElementCount()];
        for (int i = 0; i < this.getElementCount(); ++i) {
            values[i] = this.getElement(i).createNode(runtime, dataLayout, stackFactory);
        }
        return runtime.getNodeFactory().createVectorLiteralNode(values, this.getType());
    }
}

