/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDType;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.records.DwTagRecord;

public final class MDBasicType
extends MDType
implements MDBaseNode {
    private final DwarfEncoding encoding;
    private static final int ARGINDEX_TAG = 1;
    private static final int ARGINDEX_NAME = 2;
    private static final int ARGINDEX_SIZE = 3;
    private static final int ARGINDEX_ALIGN = 4;
    private static final int ARGINDEX_ENCODING = 5;
    private static final int ARGINDEX_32_NAME = 2;
    private static final int ARGINDEX_32_FILE = 3;
    private static final int ARGINDEX_32_LINE = 4;
    private static final int ARGINDEX_32_SIZE = 5;
    private static final int ARGINDEX_32_ALIGN = 6;
    private static final int ARGINDEX_32_OFFSET = 7;
    private static final int ARGINDEX_32_FLAGS = 8;
    private static final int ARGINDEX_32_ENCODING = 9;

    private MDBasicType(long tag, long line, long size, long align, long offset, long flags, long encoding) {
        super(tag, size, align, offset, line, flags);
        this.encoding = DwarfEncoding.decode(encoding);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public DwarfEncoding getEncoding() {
        return this.encoding;
    }

    public static MDBasicType create38(long[] args, MetadataValueList md) {
        long tag = args[1];
        long size = args[3];
        long align = args[4];
        long encoding = args[5];
        MDBasicType basicType = new MDBasicType(tag, -1L, size, align, -1L, -1L, encoding);
        basicType.setName(md.getNullable(args[2], basicType));
        return basicType;
    }

    public static MDBasicType create32(long[] args, Metadata md) {
        long line = ParseUtil.asInt(args, 4, md);
        long size = ParseUtil.asLong(args, 5, md);
        long align = ParseUtil.asLong(args, 6, md);
        long offset = ParseUtil.asLong(args, 7, md);
        long flags = ParseUtil.asInt(args, 8, md);
        long encoding = ParseUtil.asInt(args, 9, md);
        MDBasicType basicType = new MDBasicType(DwTagRecord.DW_TAG_BASE_TYPE.code(), line, size, align, offset, flags, encoding);
        basicType.setName(ParseUtil.resolveReference(args, 2, basicType, md));
        basicType.setFile(ParseUtil.resolveReference(args, 3, basicType, md));
        return basicType;
    }

    public static enum DwarfEncoding {
        UNKNOWN(-1),
        DW_ATE_ADDRESS(1),
        DW_ATE_BOOLEAN(2),
        DW_ATE_FLOAT(4),
        DW_ATE_SIGNED(5),
        DW_ATE_SIGNED_CHAR(6),
        DW_ATE_UNSIGNED(7),
        DW_ATE_UNSIGNED_CHAR(8);

        private static final DwarfEncoding[] VALUES;
        private final int id;

        private DwarfEncoding(int id) {
            this.id = id;
        }

        private static DwarfEncoding decode(long val) {
            for (DwarfEncoding encoding : VALUES) {
                if ((long)encoding.id != val) continue;
                return encoding;
            }
            return UNKNOWN;
        }

        static {
            VALUES = DwarfEncoding.values();
        }
    }
}

