/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.coff;

import com.oracle.truffle.llvm.parser.coff.CoffFile;
import com.oracle.truffle.llvm.parser.filereader.ObjectFileReader;
import java.util.ArrayList;
import java.util.List;

public final class ImageImportData {
    final List<ImageImportDescriptor> directoryTable;

    private ImageImportData(List<ImageImportDescriptor> directoryTable) {
        this.directoryTable = directoryTable;
    }

    static ImageImportData create(CoffFile file, ObjectFileReader reader) {
        ImageImportDescriptor importDescriptor;
        ArrayList<ImageImportDescriptor> directoryTable = new ArrayList<ImageImportDescriptor>();
        while ((importDescriptor = ImageImportDescriptor.create(file, reader)) != null) {
            directoryTable.add(importDescriptor);
        }
        return new ImageImportData(directoryTable);
    }

    public static final class ImageImportDescriptor {
        int importLookupTableRVA;
        int timeDateStamp;
        int forwarderChain;
        String name;
        int firstThunk;

        private static ImageImportDescriptor create(CoffFile file, ObjectFileReader reader) {
            ImageImportDescriptor table = new ImageImportDescriptor();
            table.importLookupTableRVA = reader.getInt();
            table.timeDateStamp = reader.getInt();
            table.forwarderChain = reader.getInt();
            int nameOffset = reader.getInt();
            table.firstThunk = reader.getInt();
            if (table.importLookupTableRVA == 0 && table.timeDateStamp == 0 && table.forwarderChain == 0 && nameOffset == 0 && table.firstThunk == 0) {
                return null;
            }
            table.name = file.readStringAtVirtualOffset(nameOffset);
            return table;
        }
    }
}

