/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.AllocExternalSymbolNode;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMScopeChain;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;

public final class InitializeOverwriteNode
extends LLVMNode {
    @Node.Child
    private AllocExternalSymbolNode allocExternalSymbol;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMFunction[] functions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMGlobal[] globals;

    public InitializeOverwriteNode(LLVMParserResult result) {
        ArrayList<LLVMFunction> functionsList = new ArrayList<LLVMFunction>();
        ArrayList<LLVMGlobal> globalsList = new ArrayList<LLVMGlobal>();
        LLVMScope fileScope = result.getRuntime().getFileScope();
        for (FunctionSymbol functionSymbol : result.getDefinedFunctions()) {
            if (!functionSymbol.isOverridable()) continue;
            LLVMFunction function = fileScope.getFunction(functionSymbol.getName());
            functionsList.add(function);
        }
        for (GlobalSymbol globalSymbol : result.getDefinedGlobals()) {
            if (!globalSymbol.isOverridable() || globalSymbol.isIntrinsicGlobalVariable()) continue;
            LLVMGlobal global = fileScope.getGlobalVariable(globalSymbol.getName());
            globalsList.add(global);
        }
        this.functions = functionsList.toArray(LLVMFunction.EMPTY);
        this.globals = globalsList.toArray(LLVMGlobal.EMPTY);
        this.allocExternalSymbol = new AllocExternalSymbolNode(result);
    }

    public void execute(LLVMContext context, LLVMScopeChain localScope, LLVMDLOpen.RTLDFlags rtldFlags) {
        LLVMPointer pointer;
        LLVMScopeChain globalScope = context.getGlobalScopeChain();
        for (LLVMFunction lLVMFunction : this.functions) {
            pointer = this.allocExternalSymbol.execute(localScope, globalScope, null, null, context, rtldFlags, lLVMFunction);
            if (pointer == null) continue;
            context.initializeSymbol(lLVMFunction, pointer);
        }
        for (LLVMSymbol lLVMSymbol : this.globals) {
            pointer = this.allocExternalSymbol.execute(localScope, globalScope, null, context, rtldFlags, (LLVMGlobal)lLVMSymbol);
            if (pointer == null) continue;
            context.initializeSymbol(lLVMSymbol, pointer);
        }
    }
}

