/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;

public abstract class InitObjcSelectorsNode
extends LLVMStatementNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMGlobal[] selectors;

    public InitObjcSelectorsNode(LLVMParserResult parserResult) {
        ArrayList<LLVMGlobal> selectorList = new ArrayList<LLVMGlobal>();
        LLVMScope fileScope = parserResult.getRuntime().getFileScope();
        for (GlobalSymbol globalSymbol : parserResult.getDefinedGlobals()) {
            GlobalVariable globalVar;
            String sectionName;
            if (!(globalSymbol instanceof GlobalVariable) || (sectionName = (globalVar = (GlobalVariable)globalSymbol).getSectionName()) == null || !sectionName.contains("__objc_selrefs")) continue;
            selectorList.add(fileScope.getGlobalVariable(globalVar.getName()));
        }
        this.selectors = selectorList.toArray(LLVMGlobal.EMPTY);
    }

    @Specialization
    void doInit(@Cached(value="getSelRegisterNameFunc()") NativeContextExtension.WellKnownNativeFunctionNode selRegisterName, @Cached BranchProfile branchProfile, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode loadNode, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storeNode) {
        LLVMContext context = this.getContext();
        for (LLVMGlobal global : this.selectors) {
            LLVMPointer storagePtr = context.getSymbol(global, branchProfile);
            LLVMPointer selector = loadNode.executeWithTarget(storagePtr, 0L);
            Object registeredSelector = null;
            try {
                registeredSelector = selRegisterName.execute(selector);
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            storeNode.executeWithTarget(storagePtr, 0L, registeredSelector);
        }
    }

    NativeContextExtension.WellKnownNativeFunctionNode getSelRegisterNameFunc() {
        LLVMContext context = this.getContext();
        NativeContextExtension nativeContextExtension = InitObjcSelectorsNode.getNativeContextExtension(context);
        return nativeContextExtension.getWellKnownNativeFunction("sel_registerName", "(POINTER):POINTER");
    }

    @CompilerDirectives.TruffleBoundary
    private static NativeContextExtension getNativeContextExtension(LLVMContext context) {
        return context.getContextExtensionOrNull(NativeContextExtension.class);
    }
}

