/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.scriptengine;

import com.oracle.truffle.js.scriptengine.GraalJSBindings;
import com.oracle.truffle.js.scriptengine.GraalJSEngineFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Predicate;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;

public final class GraalJSScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable,
AutoCloseable {
    private static final String ID = "js";
    private static final String POLYGLOT_CONTEXT = "polyglot.context";
    private static final String OUT_SYMBOL = "$$internal.out$$";
    private static final String IN_SYMBOL = "$$internal.in$$";
    private static final String ERR_SYMBOL = "$$internal.err$$";
    private static final String JS_SYNTAX_EXTENSIONS_OPTION = "js.syntax-extensions";
    private static final String JS_SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_OPTION = "js.script-engine-global-scope-import";
    private static final String JS_LOAD_OPTION = "js.load";
    private static final String JS_PRINT_OPTION = "js.print";
    private static final String SCRIPT_CONTEXT_GLOBAL_BINDINGS_IMPORT_FUNCTION_NAME = "importScriptEngineGlobalBindings";
    private static final String NASHORN_COMPATIBILITY_MODE_SYSTEM_PROPERTY = "polyglot.js.nashorn-compat";
    static final String MAGIC_OPTION_PREFIX = "polyglot.js.";
    private static final MagicBindingsOptionSetter[] MAGIC_OPTION_SETTERS = new MagicBindingsOptionSetter[]{new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowHostAccess";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowHostAccess(GraalJSScriptEngine.toBoolean(this, value) ? HostAccess.ALL : HostAccess.NONE);
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowNativeAccess";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowNativeAccess(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowCreateThread";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowCreateThread(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowIO";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowIO(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowHostClassLookup";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            if (value instanceof Boolean) {
                boolean enabled = (Boolean)value;
                return builder.allowHostClassLookup(enabled ? s -> true : null);
            }
            try {
                return builder.allowHostClassLookup((Predicate)value);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("failed to set graal-js option \"%s\": expected a boolean or Predicate<String> value, got \"%s\"", this.getOptionKey(), value));
            }
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowHostClassLoading";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowHostClassLoading(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowAllAccess";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowAllAccess(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return GraalJSScriptEngine.NASHORN_COMPATIBILITY_MODE_SYSTEM_PROPERTY;
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            boolean val = GraalJSScriptEngine.toBoolean(this, value);
            return (val ? builder.allowAllAccess(true) : builder).option("js.nashorn-compat", String.valueOf(val));
        }
    }};
    private static final EconomicSet<String> MAGIC_BINDINGS_OPTION_KEYS = EconomicSet.create();
    static final EconomicMap<String, MagicBindingsOptionSetter> MAGIC_BINDINGS_OPTION_MAP = EconomicMap.create();
    private static final boolean NASHORN_COMPATIBILITY_MODE = Boolean.getBoolean("polyglot.js.nashorn-compat");
    private final GraalJSEngineFactory factory;
    private final Context.Builder contextConfig;
    private volatile boolean closed;
    private boolean evalCalled;
    private static final String JRUNSCRIPT_INIT_NAME = "<system-init>";
    private static final String JSADAPTER_POLYFILL = "this.JSAdapter || Object.defineProperty(this, \"JSAdapter\", {configurable:true, writable:true, enumerable: false, value: function(t) {\n    var target = {};\n    var handler = {\n        get: function(target, name) {return typeof t.__get__ == 'function' ? t.__get__.call(target, name) : undefined;},\n        has: function(target, name) {return typeof t.__has__ == 'function' ? t.__has__.call(target, name) : false;},\n        deleteProperty: function(target, name) {return typeof t.__delete__ == 'function' ? t.__delete__.call(target, name) : true;},\n        set: function(target, name, value) {return typeof t.__put__ == 'function' ? t.__put__.call(target, name, value) : undefined;},\n        ownKeys: function(target) {return typeof t.__getIds__ == 'function' ? t.__getIds__.call(target) : [];},\n    }\n    return new Proxy(target, handler);\n}});\n";

    private static boolean toBoolean(MagicBindingsOptionSetter optionSetter, Object value) {
        if (!(value instanceof Boolean)) {
            throw GraalJSScriptEngine.magicOptionValueErrorBool(optionSetter.getOptionKey(), value);
        }
        return (Boolean)value;
    }

    GraalJSScriptEngine(GraalJSEngineFactory factory) {
        this(factory.getPolyglotEngine(), null);
    }

    GraalJSScriptEngine(Engine engine, Context.Builder contextConfig) {
        Context.Builder contextConfigToUse;
        Engine engineToUse = engine;
        if (engineToUse == null) {
            engineToUse = Engine.newBuilder().allowExperimentalOptions(true).build();
        }
        if ((contextConfigToUse = contextConfig) == null) {
            contextConfigToUse = Context.newBuilder((String[])new String[]{ID}).allowExperimentalOptions(true).option(JS_SYNTAX_EXTENSIONS_OPTION, "true").option(JS_LOAD_OPTION, "true").option(JS_PRINT_OPTION, "true");
            if (NASHORN_COMPATIBILITY_MODE) {
                contextConfigToUse.allowAllAccess(true);
            }
        }
        this.factory = new GraalJSEngineFactory(engineToUse);
        this.contextConfig = contextConfigToUse.option(JS_SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_OPTION, "true").engine(engineToUse);
        this.context.setBindings(new GraalJSBindings(this.contextConfig), 100);
    }

    static Context createDefaultContext(Context.Builder builder) {
        DelegatingInputStream in = new DelegatingInputStream();
        DelegatingOutputStream out = new DelegatingOutputStream();
        DelegatingOutputStream err = new DelegatingOutputStream();
        builder.in((InputStream)in).out((OutputStream)out).err((OutputStream)err);
        Context ctx = builder.build();
        ctx.getPolyglotBindings().putMember(OUT_SYMBOL, (Object)out);
        ctx.getPolyglotBindings().putMember(ERR_SYMBOL, (Object)err);
        ctx.getPolyglotBindings().putMember(IN_SYMBOL, (Object)in);
        return ctx;
    }

    @Override
    public void close() {
        this.getPolyglotContext().close();
        this.closed = true;
    }

    public Engine getPolyglotEngine() {
        return this.factory.getPolyglotEngine();
    }

    public Context getPolyglotContext() {
        return this.getPolyglotContext(this.context);
    }

    public Context getPolyglotContext(ScriptContext ctxt) {
        return this.getOrCreateGraalJSBindings(ctxt).getContext();
    }

    static Value evalInternal(Context context, String script) {
        return context.eval(Source.newBuilder((String)ID, (CharSequence)script, (String)"internal-script").internal(true).buildLiteral());
    }

    @Override
    public Bindings createBindings() {
        return new GraalJSBindings(this.contextConfig);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        return this.eval(GraalJSScriptEngine.createSource(reader, ctxt), ctxt);
    }

    private static Source createSource(Reader reader, ScriptContext ctxt) throws ScriptException {
        try {
            return Source.newBuilder((String)ID, (Reader)reader, (String)GraalJSScriptEngine.getScriptName(ctxt)).build();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        return this.eval(GraalJSScriptEngine.createSource(script, ctxt), ctxt);
    }

    private static Source createSource(String script, ScriptContext ctxt) {
        return Source.newBuilder((String)ID, (CharSequence)script, (String)GraalJSScriptEngine.getScriptName(ctxt)).buildLiteral();
    }

    private static String getScriptName(ScriptContext ctxt) {
        Object val = ctxt.getAttribute("javax.script.filename");
        return val != null ? val.toString() : "<eval>";
    }

    private Object eval(Source source, ScriptContext scriptContext) throws ScriptException {
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(scriptContext);
        Context polyglotContext = engineBindings.getContext();
        ((DelegatingOutputStream)polyglotContext.getPolyglotBindings().getMember(OUT_SYMBOL).asProxyObject()).setWriter(scriptContext.getWriter());
        ((DelegatingOutputStream)polyglotContext.getPolyglotBindings().getMember(ERR_SYMBOL).asProxyObject()).setWriter(scriptContext.getErrorWriter());
        ((DelegatingInputStream)polyglotContext.getPolyglotBindings().getMember(IN_SYMBOL).asProxyObject()).setReader(scriptContext.getReader());
        try {
            if (!this.evalCalled) {
                GraalJSScriptEngine.jrunscriptInitWorkaround(source, polyglotContext);
            }
            GraalJSScriptEngine.importGlobalBindings(scriptContext, engineBindings);
            Object object = polyglotContext.eval(source).as(Object.class);
            return object;
        }
        catch (PolyglotException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        finally {
            this.evalCalled = true;
        }
    }

    private static void importGlobalBindings(ScriptContext scriptContext, GraalJSBindings graalJSBindings) {
        Bindings globalBindings = scriptContext.getBindings(200);
        if (globalBindings != null && !globalBindings.isEmpty() && graalJSBindings != globalBindings) {
            graalJSBindings.getContext().getBindings(ID).getMember(SCRIPT_CONTEXT_GLOBAL_BINDINGS_IMPORT_FUNCTION_NAME).execute(new Object[]{globalBindings});
        }
    }

    private GraalJSBindings getOrCreateGraalJSBindings(ScriptContext scriptContext) {
        Bindings engineB = scriptContext.getBindings(100);
        if (engineB instanceof GraalJSBindings) {
            return (GraalJSBindings)engineB;
        }
        GraalJSBindings bindings = new GraalJSBindings(this.createContext(engineB));
        bindings.putAll(engineB);
        return bindings;
    }

    private Context createContext(Bindings engineB) {
        Object ctx = engineB.get(POLYGLOT_CONTEXT);
        if (!(ctx instanceof Context)) {
            Context.Builder builder = this.contextConfig;
            for (MagicBindingsOptionSetter optionSetter : MAGIC_OPTION_SETTERS) {
                Object value = engineB.get(optionSetter.getOptionKey());
                if (value == null) continue;
                builder = optionSetter.setOption(builder, value);
                engineB.remove(optionSetter.getOptionKey());
            }
            ctx = GraalJSScriptEngine.createDefaultContext(builder);
            engineB.put(POLYGLOT_CONTEXT, ctx);
        }
        return (Context)ctx;
    }

    @Override
    public GraalJSEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("thiz is not a valid object.");
        }
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(this.context);
        GraalJSScriptEngine.importGlobalBindings(this.context, engineBindings);
        Value value = engineBindings.getContext().asValue(thiz);
        Value function = value.getMember(name);
        return GraalJSScriptEngine.invokeInternal(name, function, args);
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(this.context);
        GraalJSScriptEngine.importGlobalBindings(this.context, engineBindings);
        Value value = engineBindings.getContext().getBindings(ID).getMember(name);
        return GraalJSScriptEngine.invokeInternal(name, value, args);
    }

    @Deprecated
    public static Object invoke(String methodName, Value function, Object ... args) throws NoSuchMethodException, ScriptException {
        return GraalJSScriptEngine.invokeInternal(methodName, function, args);
    }

    private static Object invokeInternal(String methodName, Value function, Object ... args) throws NoSuchMethodException, ScriptException {
        if (function == null) {
            throw new NoSuchMethodException(methodName);
        }
        if (!function.canExecute()) {
            throw new NoSuchMethodException(methodName + " is not a function");
        }
        try {
            return function.execute(args).as(Object.class);
        }
        catch (PolyglotException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return (T)GraalJSScriptEngine.evalInternal(this.getPolyglotContext(), "this").as(clasz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        return (T)this.getPolyglotContext().asValue(thiz).as(clasz);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        if (this.closed) {
            throw new IllegalStateException("Context already closed.");
        }
        final Source source = GraalJSScriptEngine.createSource(script, this.getContext());
        return new CompiledScript(){

            @Override
            public ScriptEngine getEngine() {
                return GraalJSScriptEngine.this;
            }

            @Override
            public Object eval(ScriptContext ctx) throws ScriptException {
                return GraalJSScriptEngine.this.eval(source, ctx);
            }
        };
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        if (this.closed) {
            throw new IllegalStateException("Context already closed.");
        }
        final Source source = GraalJSScriptEngine.createSource(reader, this.getContext());
        return new CompiledScript(){

            @Override
            public ScriptEngine getEngine() {
                return GraalJSScriptEngine.this;
            }

            @Override
            public Object eval(ScriptContext ctx) throws ScriptException {
                return GraalJSScriptEngine.this.eval(source, ctx);
            }
        };
    }

    public static GraalJSScriptEngine create() {
        return GraalJSScriptEngine.create(null, null);
    }

    public static GraalJSScriptEngine create(Engine engine, Context.Builder newContextConfig) {
        return new GraalJSScriptEngine(engine, newContextConfig);
    }

    private static void jrunscriptInitWorkaround(Source source, Context polyglotContext) {
        String initCode;
        if (source.getName().equals(JRUNSCRIPT_INIT_NAME) && (initCode = source.getCharacters().toString()).contains("jrunscript") && initCode.contains("JSAdapter") && !polyglotContext.getBindings(ID).hasMember("JSAdapter")) {
            polyglotContext.eval(ID, (CharSequence)JSADAPTER_POLYFILL);
        }
    }

    private static IllegalArgumentException magicOptionValueErrorBool(String name, Object v) {
        return new IllegalArgumentException(String.format("failed to set graal-js option \"%s\": expected a boolean value, got \"%s\"", name, v));
    }

    static {
        for (MagicBindingsOptionSetter setter : MAGIC_OPTION_SETTERS) {
            MAGIC_BINDINGS_OPTION_KEYS.add((Object)setter.getOptionKey());
            MAGIC_BINDINGS_OPTION_MAP.put((Object)setter.getOptionKey(), (Object)setter);
        }
    }

    private static class DelegatingOutputStream
    extends OutputStream
    implements Proxy {
        private Writer writer;

        private DelegatingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.writer != null) {
                this.writer.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
        }

        void setWriter(Writer writer) {
            this.writer = writer;
        }
    }

    private static class DelegatingInputStream
    extends InputStream
    implements Proxy {
        private Reader reader;

        private DelegatingInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.reader != null) {
                return this.reader.read();
            }
            return 0;
        }

        void setReader(Reader reader) {
            this.reader = reader;
        }
    }

    static interface MagicBindingsOptionSetter {
        public String getOptionKey();

        public Context.Builder setOption(Context.Builder var1, Object var2);
    }
}

