/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.model.resources;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.graalvm.buildtools.model.resources.ClassPathDirectoryAnalyzer;
import org.graalvm.buildtools.model.resources.JarAnalyzer;

public abstract class ClassPathEntryAnalyzer {
    private final Function<String, Boolean> resourceFilter;
    private List<String> resources;

    public static ClassPathEntryAnalyzer of(File file, Function<String, Boolean> resourceFilter, boolean ignoreExistingResourcesConfig) {
        if (file.getName().endsWith(".jar")) {
            return new JarAnalyzer(file, resourceFilter, ignoreExistingResourcesConfig);
        }
        return new ClassPathDirectoryAnalyzer(file.toPath(), resourceFilter, ignoreExistingResourcesConfig);
    }

    protected ClassPathEntryAnalyzer(Function<String, Boolean> resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public List<String> getResources() throws IOException {
        if (this.resources == null) {
            this.resources = this.initialize();
        }
        return this.resources;
    }

    protected abstract List<String> initialize() throws IOException;

    protected void maybeAddResource(String entry, List<String> resources) {
        if (entry.endsWith(".class")) {
            return;
        }
        if (this.resourceFilter.apply(entry).booleanValue()) {
            resources.add(entry);
        }
    }
}

