/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;

public class Java9 {
    private static final Logger logger = LoggerFactory.getLogger(Java9.class);
    @Nullable
    private static final Java9 instance = JavaVersion.isGreaterThanOrEqualToJava9() ? new Java9() : null;
    private final Method getModuleMethod;
    private final Object glowrootModule;
    private final Class<?> moduleClass;
    private final Method redefineModuleMethod;

    public static Object getModule(Class<?> clazz) throws Exception {
        Preconditions.checkNotNull(instance);
        return instance.getModuleInternal(clazz);
    }

    public static void grantAccessToGlowroot(Instrumentation instrumentation, Object module) throws Exception {
        Preconditions.checkNotNull(instance);
        instance.grantAccessToGlowrootInternal(instrumentation, module);
    }

    public static void grantAccess(Instrumentation instrumentation, String fromClassName, String toClassName, boolean toClassMayNotExist) throws Exception {
        Preconditions.checkNotNull(instance);
        instance.grantAccessInternal(instrumentation, fromClassName, toClassName, toClassMayNotExist);
    }

    private Java9() {
        try {
            this.getModuleMethod = Class.class.getMethod("getModule", new Class[0]);
            this.glowrootModule = Preconditions.checkNotNull(this.getModuleMethod.invoke(Java9.class, new Object[0]));
            this.moduleClass = Class.forName("java.lang.Module");
            this.redefineModuleMethod = Instrumentation.class.getMethod("redefineModule", this.moduleClass, Set.class, Map.class, Map.class, Set.class, Map.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Object getModuleInternal(Class<?> clazz) throws Exception {
        return Preconditions.checkNotNull(this.getModuleMethod.invoke(clazz, new Object[0]));
    }

    private void grantAccessToGlowrootInternal(Instrumentation instrumentation, Object module) throws Exception {
        this.redefineModuleMethod.invoke((Object)instrumentation, module, ImmutableSet.of(this.glowrootModule), ImmutableMap.of(), ImmutableMap.of(), ImmutableSet.of(), ImmutableMap.of());
    }

    private void grantAccessInternal(Instrumentation instrumentation, String fromClassName, String toClassName, boolean toClassMayNotExist) throws Exception {
        Class<?> toClass;
        Class<?> fromClass;
        try {
            fromClass = Class.forName(fromClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
            return;
        }
        try {
            toClass = Class.forName(toClassName);
        }
        catch (ClassNotFoundException e) {
            if (toClassMayNotExist) {
                logger.debug(e.getMessage(), e);
            } else {
                logger.error(e.getMessage(), e);
            }
            return;
        }
        Package pkg = toClass.getPackage();
        ImmutableMap<Object, Object> extraOpens = pkg == null ? ImmutableMap.of() : ImmutableMap.of(pkg.getName(), ImmutableSet.of(Preconditions.checkNotNull(this.getModuleMethod.invoke(fromClass, new Object[0]))));
        this.redefineModuleMethod.invoke((Object)instrumentation, Preconditions.checkNotNull(this.getModuleMethod.invoke(toClass, new Object[0])), ImmutableSet.of(), ImmutableMap.of(), extraOpens, ImmutableSet.of(), ImmutableMap.of());
    }
}

