/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import org.glowroot.agent.bytecode.api.Bytecode;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.util.ImmutableMap;
import org.glowroot.agent.plugin.api.util.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.com.google.common.reflect.Reflection;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Beans;
import org.glowroot.agent.weaving.ClassNames;
import org.glowroot.agent.weaving.Weaver;

@OnlyUsedByTests
public class IsolatedWeavingClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(IsolatedWeavingClassLoader.class);
    private final ImmutableList<Class<?>> bridgeClasses;
    private final Map<String, Class<?>> classes = Maps.newConcurrentMap();
    private final Map<String, Package> packages = Maps.newConcurrentMap();
    private final Map<String, byte[]> manualClasses = Maps.newConcurrentMap();
    @MonotonicNonNull
    private volatile Weaver weaver;
    private final ThreadLocal<Boolean> inWeaving = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public IsolatedWeavingClassLoader(Class<?> ... bridgeClasses) {
        super(IsolatedWeavingClassLoader.class.getClassLoader());
        this.bridgeClasses = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(bridgeClasses)).add(IsolatedWeavingClassLoader.class)).add(Weaver.class)).build();
    }

    public void setWeaver(Weaver weaver) {
        this.weaver = weaver;
    }

    public void addManualClass(String name, byte[] bytes) {
        this.manualClasses.put(name, bytes);
    }

    public <S, T extends S> S newInstance(Class<T> implClass, Class<S> bridgeClass) throws Exception {
        this.validateBridgeable(bridgeClass.getName());
        return bridgeClass.cast(this.loadClass(implClass.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (IsolatedWeavingClassLoader.loadWithParentClassLoader(name)) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.classes.get(name);
        if (c != null) {
            return c;
        }
        c = this.findClass(name);
        this.classes.put(name, c);
        return c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        void var3_6;
        for (Class clazz : this.bridgeClasses) {
            if (!clazz.getName().equals(name)) continue;
            return clazz;
        }
        byte[] bytes = this.manualClasses.get(name);
        Object var3_4 = null;
        if (bytes == null) {
            String resourceName = ClassNames.toInternalName(name) + ".class";
            URL url = this.getResource(resourceName);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                bytes = Resources.toByteArray(url);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Error loading class", e);
            }
            String path = url.getPath();
            if (url.getProtocol().equals("jar")) {
                int index = path.indexOf("!/");
                File jarFile = new File(path.substring(5, index));
                try {
                    CodeSource codeSource = new CodeSource(jarFile.toURI().toURL(), (CodeSigner[])null);
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return this.weaveAndDefineClass(name, bytes, (CodeSource)var3_6);
    }

    @Override
    @Nullable
    protected Package getPackage(String name) {
        return this.packages.get(name);
    }

    public Class<?> weaveAndDefineClass(String name, byte[] bytes, @Nullable CodeSource codeSource) {
        byte[] wovenBytes = this.weaveClass(name, bytes);
        String packageName = Reflection.getPackageName(name);
        if (!this.packages.containsKey(packageName)) {
            Package pkg;
            Method getDefinedPackageMethod;
            try {
                getDefinedPackageMethod = this.getClass().getMethod("getDefinedPackage", String.class);
            }
            catch (NoSuchMethodException e) {
                getDefinedPackageMethod = null;
            }
            if (getDefinedPackageMethod == null) {
                pkg = this.definePackage(packageName, null, null, null, null, null, null, null);
            } else {
                try {
                    pkg = (Package)getDefinedPackageMethod.invoke((Object)this, packageName);
                    if (pkg == null) {
                        pkg = this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.packages.put(packageName, pkg);
        }
        if (codeSource == null) {
            return super.defineClass(name, wovenBytes, 0, wovenBytes.length);
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, null);
        return super.defineClass(name, wovenBytes, 0, wovenBytes.length, protectionDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] weaveClass(String name, byte[] bytes) {
        if (this.weaver == null || this.inWeaving.get().booleanValue()) {
            return bytes;
        }
        this.inWeaving.set(true);
        try {
            byte[] wovenBytes = this.weaver.weave(bytes, ClassNames.toInternalName(name), null, null, this);
            if (wovenBytes == null) {
                byte[] byArray = bytes;
                return byArray;
            }
            logger.debug("findClass(): transformed {}", (Object)name);
            byte[] byArray = wovenBytes;
            return byArray;
        }
        finally {
            this.inWeaving.remove();
        }
    }

    private void validateBridgeable(String name) {
        if (IsolatedWeavingClassLoader.isInBootstrapClassLoader(name)) {
            return;
        }
        for (Class clazz : this.bridgeClasses) {
            if (!clazz.getName().equals(name)) continue;
            return;
        }
        throw new IllegalStateException("Class '" + name + "' is not bridgeable");
    }

    public static boolean loadWithParentClassLoader(String name) {
        if (IsolatedWeavingClassLoader.isInBootstrapClassLoader(name)) {
            return true;
        }
        if (name.startsWith("java.")) {
            return true;
        }
        if (name.equals(Agent.class.getName()) || name.equals(Bytecode.class.getName()) || name.equals(org.glowroot.agent.plugin.api.util.ImmutableList.class.getName()) || name.equals(ImmutableMap.class.getName()) || name.equals(ImmutableSet.class.getName()) || name.equals(Beans.class.getName())) {
            return false;
        }
        return name.startsWith("org.glowroot.agent.api.") || name.startsWith("org.glowroot.agent.plugin.api.") || name.startsWith("org.glowroot.agent.bytecode.api.");
    }

    private static boolean isInBootstrapClassLoader(String name) {
        try {
            Class<?> cls = Class.forName(name, false, ClassLoader.getSystemClassLoader());
            return cls.getClassLoader() == null;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), e);
            return false;
        }
    }
}

