/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.PluginDetail;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PluginDetail.MixinClass", generator="Immutables")
@Immutable
public final class ImmutableMixinClass
extends PluginDetail.MixinClass {
    private final Type type;
    private final ImmutableList<Type> interfaces;
    private final Mixin mixin;
    @Nullable
    private final String initMethodName;
    private final byte[] bytes;

    private ImmutableMixinClass(Type type, ImmutableList<Type> interfaces, Mixin mixin, @Nullable String initMethodName, byte[] bytes) {
        this.type = type;
        this.interfaces = interfaces;
        this.mixin = mixin;
        this.initMethodName = initMethodName;
        this.bytes = bytes;
    }

    @Override
    @JsonProperty(value="type")
    Type type() {
        return this.type;
    }

    @JsonProperty(value="interfaces")
    ImmutableList<Type> interfaces() {
        return this.interfaces;
    }

    @Override
    @JsonProperty(value="mixin")
    Mixin mixin() {
        return this.mixin;
    }

    @Override
    @JsonProperty(value="initMethodName")
    @Nullable
    String initMethodName() {
        return this.initMethodName;
    }

    @Override
    @JsonProperty(value="bytes")
    byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    public final ImmutableMixinClass withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value, "type");
        return new ImmutableMixinClass(newValue, this.interfaces, this.mixin, this.initMethodName, this.bytes);
    }

    public final ImmutableMixinClass withInterfaces(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMixinClass(this.type, newValue, this.mixin, this.initMethodName, this.bytes);
    }

    public final ImmutableMixinClass withInterfaces(Iterable<? extends Type> elements) {
        if (this.interfaces == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMixinClass(this.type, newValue, this.mixin, this.initMethodName, this.bytes);
    }

    public final ImmutableMixinClass withMixin(Mixin value) {
        if (this.mixin == value) {
            return this;
        }
        Mixin newValue = Preconditions.checkNotNull(value, "mixin");
        return new ImmutableMixinClass(this.type, this.interfaces, newValue, this.initMethodName, this.bytes);
    }

    public final ImmutableMixinClass withInitMethodName(@Nullable String value) {
        if (Objects.equal(this.initMethodName, value)) {
            return this;
        }
        return new ImmutableMixinClass(this.type, this.interfaces, this.mixin, value, this.bytes);
    }

    public final ImmutableMixinClass withBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableMixinClass(this.type, this.interfaces, this.mixin, this.initMethodName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMixinClass && this.equalTo((ImmutableMixinClass)another);
    }

    private boolean equalTo(ImmutableMixinClass another) {
        return this.type.equals(another.type) && this.interfaces.equals(another.interfaces) && this.mixin.equals(another.mixin) && Objects.equal(this.initMethodName, another.initMethodName) && Arrays.equals(this.bytes, another.bytes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.interfaces.hashCode();
        h += (h << 5) + this.mixin.hashCode();
        h += (h << 5) + Objects.hashCode(this.initMethodName);
        h += (h << 5) + Arrays.hashCode(this.bytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MixinClass").omitNullValues().add("type", this.type).add("interfaces", this.interfaces).add("mixin", this.mixin).add("initMethodName", this.initMethodName).add("bytes", Arrays.toString(this.bytes)).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMixinClass fromJson(Json json) {
        Builder builder = ImmutableMixinClass.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.interfaces != null) {
            builder.addAllInterfaces(json.interfaces);
        }
        if (json.mixin != null) {
            builder.mixin(json.mixin);
        }
        if (json.initMethodName != null) {
            builder.initMethodName(json.initMethodName);
        }
        if (json.bytes != null) {
            builder.bytes(json.bytes);
        }
        return builder.build();
    }

    public static ImmutableMixinClass copyOf(PluginDetail.MixinClass instance) {
        if (instance instanceof ImmutableMixinClass) {
            return (ImmutableMixinClass)instance;
        }
        return ImmutableMixinClass.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PluginDetail.MixinClass", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_MIXIN = 2L;
        private static final long INIT_BIT_BYTES = 4L;
        private long initBits = 7L;
        @Nullable
        private Type type;
        private ImmutableList.Builder<Type> interfaces = ImmutableList.builder();
        @Nullable
        private Mixin mixin;
        @Nullable
        private String initMethodName;
        @Nullable
        private byte[] bytes;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PluginDetail.MixinClass instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.type(instance.type());
            this.addAllInterfaces(instance.interfaces());
            this.mixin(instance.mixin());
            String initMethodNameValue = instance.initMethodName();
            if (initMethodNameValue != null) {
                this.initMethodName(initMethodNameValue);
            }
            this.bytes(instance.bytes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Type type) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInterfaces(Type element) {
            this.interfaces.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInterfaces(Type ... elements) {
            this.interfaces.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder interfaces(Iterable<? extends Type> elements) {
            this.interfaces = ImmutableList.builder();
            return this.addAllInterfaces(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInterfaces(Iterable<? extends Type> elements) {
            this.interfaces.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mixin(Mixin mixin) {
            this.mixin = Preconditions.checkNotNull(mixin, "mixin");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initMethodName(@Nullable String initMethodName) {
            this.initMethodName = initMethodName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytes(byte ... bytes) {
            this.bytes = (byte[])bytes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMixinClass build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMixinClass(this.type, (ImmutableList)this.interfaces.build(), this.mixin, this.initMethodName, this.bytes);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mixin");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bytes");
            }
            return "Cannot build MixinClass, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PluginDetail.MixinClass", generator="Immutables")
    static final class Json
    extends PluginDetail.MixinClass {
        @Nullable
        Type type;
        @Nullable
        List<Type> interfaces = ImmutableList.of();
        @Nullable
        Mixin mixin;
        @Nullable
        String initMethodName;
        @Nullable
        byte[] bytes;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(Type type) {
            this.type = type;
        }

        @JsonProperty(value="interfaces")
        public void setInterfaces(List<Type> interfaces) {
            this.interfaces = interfaces;
        }

        @JsonProperty(value="mixin")
        public void setMixin(Mixin mixin) {
            this.mixin = mixin;
        }

        @JsonProperty(value="initMethodName")
        public void setInitMethodName(@Nullable String initMethodName) {
            this.initMethodName = initMethodName;
        }

        @JsonProperty(value="bytes")
        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        Type type() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<Type> interfaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        Mixin mixin() {
            throw new UnsupportedOperationException();
        }

        @Override
        String initMethodName() {
            throw new UnsupportedOperationException();
        }

        @Override
        byte[] bytes() {
            throw new UnsupportedOperationException();
        }
    }
}

