/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class Reflections {
    private static final Logger logger = LoggerFactory.getLogger(Reflections.class);

    private Reflections() {
    }

    public static Method getAnyMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            logger.trace(e.getMessage(), e);
            return Reflections.getAnyDeclaredMethod(clazz, name, parameterTypes);
        }
        catch (NoClassDefFoundError e) {
            logger.trace(e.getMessage(), e);
            return Reflections.getAnyDeclaredMethod(clazz, name, parameterTypes);
        }
    }

    public static Field getAnyField(Class<?> clazz, String fieldName) throws Exception {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.trace(e.getMessage(), e);
            return Reflections.getAnyDeclaredField(clazz, fieldName);
        }
    }

    private static Method getAnyDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Reflections.getAnyDeclaredMethod(superClass, name, parameterTypes);
        }
        catch (NoClassDefFoundError e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw new NoSuchMethodException();
            }
            return Reflections.getAnyDeclaredMethod(superClass, name, parameterTypes);
        }
    }

    private static Field getAnyDeclaredField(Class<?> clazz, String fieldName) throws Exception {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Reflections.getAnyDeclaredField(superClass, fieldName);
        }
    }
}

