/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import org.glowroot.agent.shaded.com.google.common.util.concurrent.RateLimiter;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class RateLimitedLogger {
    private final Logger logger;
    private final RateLimiter warningRateLimiter = RateLimiter.create(0.016666666666666666);
    @GuardedBy(value="warningRateLimiter")
    private int countSinceLastWarning;

    public RateLimitedLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String format, Object ... args) {
        int countSinceLastWarning = 0;
        boolean logWarning = false;
        RateLimiter rateLimiter = this.warningRateLimiter;
        synchronized (rateLimiter) {
            if (this.warningRateLimiter.tryAcquire()) {
                logWarning = true;
                countSinceLastWarning = this.countSinceLastWarning;
                this.countSinceLastWarning = 0;
            } else {
                ++this.countSinceLastWarning;
            }
        }
        if (logWarning) {
            if (countSinceLastWarning == 0) {
                this.logger.warn(format + " (this warning will be logged at most once a minute)", args);
            } else {
                Object[] argsPlus = RateLimitedLogger.newArgsWithCountSinceLastWarning(args, countSinceLastWarning);
                this.logger.warn(format + " (this warning will be logged at most once a minute, {} warnings were suppressed since it was last logged)", argsPlus);
            }
        }
    }

    @Nullable
    static Object[] newArgsWithCountSinceLastWarning(Object[] args, int countSinceLastWarning) {
        if (args.length == 0) {
            return new Object[]{countSinceLastWarning};
        }
        Object[] argsPlus = new Object[args.length + 1];
        if (args[args.length - 1] instanceof Throwable) {
            System.arraycopy(args, 0, argsPlus, 0, args.length - 1);
            argsPlus[args.length - 1] = countSinceLastWarning;
            argsPlus[args.length] = args[args.length - 1];
            return argsPlus;
        }
        System.arraycopy(args, 0, argsPlus, 0, args.length);
        argsPlus[args.length] = countSinceLastWarning;
        return argsPlus;
    }
}

