/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;

public abstract class OptionalService<T> {
    static <T> OptionalService<T> available(T service) {
        return new PresentOptionalService<T>(service);
    }

    static <T> OptionalService<T> unavailable(String reason) {
        return new AbsentOptionalService(reason);
    }

    public abstract DownstreamServiceOuterClass.Availability getAvailability();

    @Nullable
    public abstract T getService();

    private static class AbsentOptionalService<T>
    extends OptionalService<T> {
        private final DownstreamServiceOuterClass.Availability availability;

        public AbsentOptionalService(String reason) {
            this.availability = DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(false).setReason(reason).build();
        }

        @Override
        public DownstreamServiceOuterClass.Availability getAvailability() {
            return this.availability;
        }

        @Override
        @Nullable
        public T getService() {
            return null;
        }
    }

    private static class PresentOptionalService<T>
    extends OptionalService<T> {
        private final DownstreamServiceOuterClass.Availability availability = DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(true).build();
        private final T service;

        public PresentOptionalService(T service) {
            this.service = service;
        }

        @Override
        public DownstreamServiceOuterClass.Availability getAvailability() {
            return this.availability;
        }

        @Override
        public T getService() {
            return this.service;
        }
    }
}

