/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.io.Files;

public class PropertiesFiles {
    private PropertiesFiles() {
    }

    public static Properties load(File propFile) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propFile);
        try {
            props.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
        return props;
    }

    public static void upgradeIfNeeded(File propFile, Map<String, String> findReplacePairs) throws IOException {
        String content = Files.toString(propFile, Charsets.ISO_8859_1);
        boolean modified = false;
        for (Map.Entry<String, String> entry : findReplacePairs.entrySet()) {
            String find = entry.getKey();
            if (!content.contains(find)) continue;
            content = content.replace(find, entry.getValue());
            modified = true;
        }
        if (modified) {
            Files.write(content, propFile, Charsets.ISO_8859_1);
        }
    }
}

