/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableQuery;

public class QueryCollector {
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private final Map<String, Map<String, MutableQuery>> queries = Maps.newHashMap();
    private final Map<String, MutableQuery> limitExceededBuckets = Maps.newHashMap();
    private final int limit;
    private long lastCaptureTime;

    public QueryCollector(int limit) {
        this.limit = limit;
    }

    public void updateLastCaptureTime(long captureTime) {
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public List<MutableQuery> getSortedAndTruncatedQueries() {
        List<MutableQuery> allQueries = Lists.newArrayList();
        for (Map.Entry<String, Map<String, MutableQuery>> outerEntry : this.queries.entrySet()) {
            allQueries.addAll(outerEntry.getValue().values());
        }
        if (allQueries.size() <= this.limit) {
            allQueries.addAll(this.limitExceededBuckets.values());
            return MutableQuery.byTotalDurationDesc.sortedCopy(allQueries);
        }
        allQueries = MutableQuery.byTotalDurationDesc.sortedCopy(allQueries);
        List exceededQueries = allQueries.subList(this.limit, allQueries.size());
        allQueries = Lists.newArrayList(allQueries.subList(0, this.limit));
        Map<String, MutableQuery> limitExceededBuckets = this.copyLimitExceededBuckets();
        for (MutableQuery exceededQuery : exceededQueries) {
            String queryType = exceededQuery.getType();
            MutableQuery limitExceededBucket = limitExceededBuckets.get(queryType);
            if (limitExceededBucket == null) {
                limitExceededBucket = new MutableQuery(queryType, LIMIT_EXCEEDED_BUCKET, null);
                limitExceededBuckets.put(queryType, limitExceededBucket);
            }
            limitExceededBucket.add(exceededQuery);
        }
        allQueries.addAll(limitExceededBuckets.values());
        Collections.sort(allQueries, MutableQuery.byTotalDurationDesc);
        return allQueries;
    }

    public void mergeQuery(String queryType, String truncatedText, @Nullable String fullTextSha1, double totalDurationNanos, long executionCount, boolean hasRows, long totalRows) {
        MutableQuery aggregateQuery;
        if (truncatedText.equals(LIMIT_EXCEEDED_BUCKET)) {
            aggregateQuery = this.limitExceededBuckets.get(queryType);
            if (aggregateQuery == null) {
                aggregateQuery = new MutableQuery(queryType, LIMIT_EXCEEDED_BUCKET, null);
                this.limitExceededBuckets.put(queryType, aggregateQuery);
            }
        } else {
            String queryKey;
            Map<String, MutableQuery> queriesForType = this.queries.get(queryType);
            if (queriesForType == null) {
                queriesForType = Maps.newHashMap();
                this.queries.put(queryType, queriesForType);
            }
            if ((aggregateQuery = queriesForType.get(queryKey = MoreObjects.firstNonNull(fullTextSha1, truncatedText))) == null) {
                aggregateQuery = new MutableQuery(queryType, truncatedText, fullTextSha1);
                queriesForType.put(queryKey, aggregateQuery);
            }
        }
        aggregateQuery.addToTotalDurationNanos(totalDurationNanos);
        aggregateQuery.addToExecutionCount(executionCount);
        aggregateQuery.addToTotalRows(hasRows, totalRows);
    }

    private Map<String, MutableQuery> copyLimitExceededBuckets() {
        HashMap<String, MutableQuery> copies = Maps.newHashMap();
        for (Map.Entry<String, MutableQuery> entry : this.limitExceededBuckets.entrySet()) {
            String queryType = entry.getKey();
            MutableQuery limitExceededBucket = entry.getValue();
            MutableQuery copy = new MutableQuery(queryType, LIMIT_EXCEEDED_BUCKET, null);
            copy.add(limitExceededBucket);
            copies.put(queryType, copy);
        }
        return copies;
    }
}

