/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TransactionNameSummaryCollector.TransactionNameSummary", generator="Immutables")
@Immutable
public final class ImmutableTransactionNameSummary
implements TransactionNameSummaryCollector.TransactionNameSummary {
    private final String transactionName;
    private final double totalDurationNanos;
    private final long transactionCount;

    private ImmutableTransactionNameSummary(String transactionName, double totalDurationNanos, long transactionCount) {
        this.transactionName = transactionName;
        this.totalDurationNanos = totalDurationNanos;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final ImmutableTransactionNameSummary withTransactionName(String value) {
        String newValue = Preconditions.checkNotNull(value, "transactionName");
        if (this.transactionName.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionNameSummary(newValue, this.totalDurationNanos, this.transactionCount);
    }

    public final ImmutableTransactionNameSummary withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableTransactionNameSummary(this.transactionName, value, this.transactionCount);
    }

    public final ImmutableTransactionNameSummary withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutableTransactionNameSummary(this.transactionName, this.totalDurationNanos, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionNameSummary && this.equalTo((ImmutableTransactionNameSummary)another);
    }

    private boolean equalTo(ImmutableTransactionNameSummary another) {
        return this.transactionName.equals(another.transactionName) && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionName.hashCode();
        h += (h << 5) + Doubles.hashCode(this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionNameSummary").omitNullValues().add("transactionName", this.transactionName).add("totalDurationNanos", this.totalDurationNanos).add("transactionCount", this.transactionCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionNameSummary fromJson(Json json) {
        Builder builder = ImmutableTransactionNameSummary.builder();
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        return builder.build();
    }

    public static ImmutableTransactionNameSummary copyOf(TransactionNameSummaryCollector.TransactionNameSummary instance) {
        if (instance instanceof ImmutableTransactionNameSummary) {
            return (ImmutableTransactionNameSummary)instance;
        }
        return ImmutableTransactionNameSummary.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionNameSummaryCollector.TransactionNameSummary", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_NAME = 1L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 2L;
        private static final long INIT_BIT_TRANSACTION_COUNT = 4L;
        private long initBits = 7L;
        @Nullable
        private String transactionName;
        private double totalDurationNanos;
        private long transactionCount;

        private Builder() {
        }

        public final Builder copyFrom(TransactionNameSummaryCollector.TransactionNameSummary instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.transactionName(instance.transactionName());
            this.totalDurationNanos(instance.totalDurationNanos());
            this.transactionCount(instance.transactionCount());
            return this;
        }

        public final Builder transactionName(String transactionName) {
            this.transactionName = Preconditions.checkNotNull(transactionName, "transactionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTransactionNameSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionNameSummary(this.transactionName, this.totalDurationNanos, this.transactionCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transactionCount");
            }
            return "Cannot build TransactionNameSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionNameSummaryCollector.TransactionNameSummary", generator="Immutables")
    static final class Json
    implements TransactionNameSummaryCollector.TransactionNameSummary {
        @Nullable
        String transactionName;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long transactionCount;
        boolean transactionCountIsSet;

        Json() {
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @Override
        public String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }
    }
}

