/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.Locale;
import org.glowroot.agent.shaded.org.checkerframework.checker.tainting.qual.Untainted;

public enum StringComparator {
    BEGINS("like", "%s%%"){

        @Override
        public boolean matches(String text, String partial) {
            return StringComparator.upper(text).startsWith(StringComparator.upper(partial));
        }
    }
    ,
    EQUALS("=", "%s"){

        @Override
        public boolean matches(String text, String partial) {
            return text.equalsIgnoreCase(partial);
        }
    }
    ,
    ENDS("like", "%%%s"){

        @Override
        public boolean matches(String text, String partial) {
            return StringComparator.upper(text).endsWith(StringComparator.upper(partial));
        }
    }
    ,
    CONTAINS("like", "%%%s%%"){

        @Override
        public boolean matches(String text, String partial) {
            return StringComparator.upper(text).contains(StringComparator.upper(partial));
        }
    }
    ,
    NOT_CONTAINS("not like", "%%%s%%"){

        @Override
        public boolean matches(String text, String partial) {
            return !StringComparator.upper(text).contains(StringComparator.upper(partial));
        }
    };

    @Untainted
    private final String comparator;
    private final String parameterFormat;

    private StringComparator(String comparator, String parameterTemplate) {
        this.comparator = comparator;
        this.parameterFormat = parameterTemplate;
    }

    public String formatParameter(String parameter) {
        return String.format(this.parameterFormat, StringComparator.upper(parameter));
    }

    @Untainted
    public String getComparator() {
        return this.comparator;
    }

    public abstract boolean matches(String var1, String var2);

    private static String upper(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }
}

