/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.immutables.value.Value;

public interface LiveAggregateRepository {
    public long mergeInOverallSummary(String var1, SummaryQuery var2, OverallSummaryCollector var3);

    public long mergeInTransactionNameSummaries(String var1, SummaryQuery var2, TransactionNameSummaryCollector var3);

    public long mergeInOverallErrorSummary(String var1, SummaryQuery var2, OverallErrorSummaryCollector var3);

    public long mergeInTransactionNameErrorSummaries(String var1, SummaryQuery var2, TransactionNameErrorSummaryCollector var3);

    public Set<String> getTransactionTypes(String var1);

    @Nullable
    public LiveResult<OverviewAggregate> getOverviewAggregates(String var1, AggregateQuery var2);

    @Nullable
    public LiveResult<PercentileAggregate> getPercentileAggregates(String var1, AggregateQuery var2);

    @Nullable
    public LiveResult<ThroughputAggregate> getThroughputAggregates(String var1, AggregateQuery var2);

    @Nullable
    public String getFullQueryText(String var1, String var2);

    public long mergeInQueries(String var1, AggregateQuery var2, QueryCollector var3) throws IOException;

    public long mergeInServiceCalls(String var1, AggregateQuery var2, ServiceCallCollector var3) throws IOException;

    public long mergeInMainThreadProfiles(String var1, AggregateQuery var2, ProfileCollector var3);

    public long mergeInAuxThreadProfiles(String var1, AggregateQuery var2, ProfileCollector var3);

    public void clearInMemoryData();

    public static class LiveAggregateRepositoryNop
    implements LiveAggregateRepository {
        @Override
        public long mergeInOverallSummary(String agentId, SummaryQuery query, OverallSummaryCollector collector) {
            return query.to();
        }

        @Override
        public long mergeInTransactionNameSummaries(String agentId, SummaryQuery query, TransactionNameSummaryCollector collector) {
            return query.to();
        }

        @Override
        public long mergeInOverallErrorSummary(String agentId, SummaryQuery query, OverallErrorSummaryCollector collector) {
            return query.to();
        }

        @Override
        public long mergeInTransactionNameErrorSummaries(String agentId, SummaryQuery query, TransactionNameErrorSummaryCollector collector) {
            return query.to();
        }

        @Override
        public Set<String> getTransactionTypes(String agentId) {
            return Sets.newHashSet();
        }

        @Override
        @Nullable
        public LiveResult<OverviewAggregate> getOverviewAggregates(String agentId, AggregateQuery query) {
            return null;
        }

        @Override
        @Nullable
        public LiveResult<PercentileAggregate> getPercentileAggregates(String agentId, AggregateQuery query) {
            return null;
        }

        @Override
        @Nullable
        public LiveResult<ThroughputAggregate> getThroughputAggregates(String agentId, AggregateQuery query) {
            return null;
        }

        @Override
        @Nullable
        public String getFullQueryText(String agentRollupId, String fullQueryTextSha1) {
            return null;
        }

        @Override
        public long mergeInQueries(String agentId, AggregateQuery query, QueryCollector collector) {
            return query.to();
        }

        @Override
        public long mergeInServiceCalls(String agentId, AggregateQuery query, ServiceCallCollector collector) {
            return query.to();
        }

        @Override
        public long mergeInMainThreadProfiles(String agentId, AggregateQuery query, ProfileCollector collector) {
            return query.to();
        }

        @Override
        public long mergeInAuxThreadProfiles(String agentId, AggregateQuery query, ProfileCollector collector) {
            return query.to();
        }

        @Override
        public void clearInMemoryData() {
        }
    }

    public static class LiveResult<T> {
        private final List<T> result;
        private final long revisedTo;

        public LiveResult(List<T> result, long revisedTo) {
            this.result = result;
            this.revisedTo = revisedTo;
        }

        public List<T> get() {
            return this.result;
        }

        public long revisedTo() {
            return this.revisedTo;
        }
    }

    @Value.Immutable
    public static interface ThroughputAggregate {
        public long captureTime();

        public long transactionCount();

        @Nullable
        public Long errorCount();
    }

    @Value.Immutable
    public static interface PercentileAggregate {
        public long captureTime();

        public double totalDurationNanos();

        public long transactionCount();

        public AggregateOuterClass.Aggregate.Histogram durationNanosHistogram();
    }

    @Value.Immutable
    public static interface OverviewAggregate {
        public long captureTime();

        public double totalDurationNanos();

        public long transactionCount();

        public boolean asyncTransactions();

        public List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers();

        public AggregateOuterClass.Aggregate.ThreadStats mainThreadStats();

        @Nullable
        public AggregateOuterClass.Aggregate.Timer auxThreadRootTimer();

        @Nullable
        public AggregateOuterClass.Aggregate.ThreadStats auxThreadStats();

        public List<AggregateOuterClass.Aggregate.Timer> asyncTimers();
    }

    @Value.Immutable
    public static interface AggregateQuery {
        public String transactionType();

        @Nullable
        public String transactionName();

        public long from();

        public long to();

        public int rollupLevel();
    }

    @Value.Immutable
    public static interface SummaryQuery {
        public String transactionType();

        public long from();

        public long to();

        public int rollupLevel();
    }
}

