/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonToken;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;

@JsonSerialize(using=PropertyValueSerializer.class)
@JsonDeserialize(using=PropertyValueDeserializer.class)
public class PropertyValue {
    @Nullable
    private final Object value;

    public PropertyValue(@Nullable Object value) {
        this.value = value;
    }

    @Nullable
    public Object value() {
        return this.value;
    }

    public AgentConfigOuterClass.AgentConfig.PluginProperty.Value toProto() {
        AgentConfigOuterClass.AgentConfig.PluginProperty.Value.Builder propertyValue = AgentConfigOuterClass.AgentConfig.PluginProperty.Value.newBuilder();
        if (this.value == null) {
            propertyValue.setDvalNull(true);
        } else if (this.value instanceof Boolean) {
            propertyValue.setBval((Boolean)this.value);
        } else if (this.value instanceof String) {
            propertyValue.setSval((String)this.value);
        } else if (this.value instanceof Double) {
            propertyValue.setDval((Double)this.value);
        } else if (this.value instanceof List) {
            AgentConfigOuterClass.AgentConfig.PluginProperty.StringList.Builder lval = AgentConfigOuterClass.AgentConfig.PluginProperty.StringList.newBuilder();
            for (Object v : (List)this.value) {
                lval.addVal((String)Preconditions.checkNotNull(v));
            }
            propertyValue.setLval(lval);
        } else {
            throw new AssertionError((Object)("Unexpected property value type: " + this.value.getClass().getName()));
        }
        return propertyValue.build();
    }

    public static PropertyValue create(AgentConfigOuterClass.AgentConfig.PluginProperty.Value value) {
        switch (value.getValCase()) {
            case BVAL: {
                return new PropertyValue(value.getBval());
            }
            case DVAL_NULL: {
                return new PropertyValue(null);
            }
            case DVAL: {
                return new PropertyValue(value.getDval());
            }
            case SVAL: {
                return new PropertyValue(value.getSval());
            }
            case LVAL: {
                return new PropertyValue(ImmutableList.copyOf(value.getLval().getValList()));
            }
        }
        throw new IllegalStateException("Unexpected plugin property type: " + value.getValCase());
    }

    static class PropertyValueDeserializer
    extends JsonDeserializer<PropertyValue> {
        PropertyValueDeserializer() {
        }

        @Override
        public PropertyValue deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            JsonToken token = parser.getCurrentToken();
            switch (token) {
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    return new PropertyValue(parser.getBooleanValue());
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    return new PropertyValue(parser.getDoubleValue());
                }
                case VALUE_STRING: {
                    return new PropertyValue(parser.getText());
                }
                case START_ARRAY: {
                    ArrayList<String> list = Lists.newArrayList();
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        list.add(parser.getText());
                    }
                    return new PropertyValue(list);
                }
            }
            throw new AssertionError((Object)("Unexpected json type: " + (Object)((Object)token)));
        }

        @Override
        public PropertyValue getNullValue(DeserializationContext ctxt) {
            return new PropertyValue(null);
        }
    }

    static class PropertyValueSerializer
    extends JsonSerializer<PropertyValue> {
        PropertyValueSerializer() {
        }

        @Override
        public void serialize(PropertyValue propertyValue, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Object value = propertyValue.value();
            if (value == null) {
                jgen.writeNull();
            } else if (value instanceof Boolean) {
                jgen.writeBoolean((Boolean)value);
            } else if (value instanceof String) {
                jgen.writeString((String)value);
            } else if (value instanceof Double) {
                jgen.writeNumber((Double)value);
            } else if (value instanceof List) {
                jgen.writeStartArray();
                for (Object v : (List)value) {
                    jgen.writeString((String)v);
                }
                jgen.writeEndArray();
            } else {
                throw new AssertionError((Object)("Unexpected property value type: " + value.getClass().getName()));
            }
        }
    }

    public static enum PropertyType {
        STRING,
        BOOLEAN,
        DOUBLE,
        LIST;

    }
}

