/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.stats;

import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.io.opencensus.internal.Provider;
import org.glowroot.agent.shaded.io.opencensus.stats.NoopStats;
import org.glowroot.agent.shaded.io.opencensus.stats.StatsComponent;
import org.glowroot.agent.shaded.io.opencensus.stats.StatsRecorder;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

public final class Stats {
    private static final Logger logger = Logger.getLogger(Stats.class.getName());
    private static final StatsComponent statsComponent = Stats.loadStatsComponent(StatsComponent.class.getClassLoader());

    public static StatsRecorder getStatsRecorder() {
        return statsComponent.getStatsRecorder();
    }

    static StatsComponent loadStatsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("org.glowroot.agent.shaded.io.opencensus.impl.stats.StatsComponentImpl", true, classLoader), StatsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for StatsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("org.glowroot.agent.shaded.io.opencensus.impllite.stats.StatsComponentImplLite", true, classLoader), StatsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for StatsComponent, now using default implementation for StatsComponent.", e2);
                return NoopStats.newNoopStatsComponent();
            }
        }
    }

    private Stats() {
    }
}

