/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.http2;

import java.util.concurrent.TimeUnit;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBuf;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBufUtil;
import org.glowroot.agent.shaded.io.netty.buffer.Unpooled;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandlerContext;
import org.glowroot.agent.shaded.io.netty.channel.ChannelPromise;
import org.glowroot.agent.shaded.io.netty.channel.DefaultChannelPromise;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Error;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Flags;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.StreamByteDistributor;
import org.glowroot.agent.shaded.io.netty.util.AsciiString;
import org.glowroot.agent.shaded.io.netty.util.CharsetUtil;
import org.glowroot.agent.shaded.io.netty.util.concurrent.EventExecutor;

public final class Http2CodecUtil {
    public static final CharSequence HTTP_UPGRADE_SETTINGS_HEADER = AsciiString.cached("HTTP2-Settings");
    public static final CharSequence HTTP_UPGRADE_PROTOCOL_NAME = "h2c";
    public static final CharSequence TLS_UPGRADE_PROTOCOL_NAME = "h2";
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer(Unpooled.directBuffer(24).writeBytes("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(CharsetUtil.UTF_8))).asReadOnly();
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);

    public static long calculateMaxHeaderListSizeGoAway(long maxHeaderListSize) {
        return maxHeaderListSize + (maxHeaderListSize >>> 2);
    }

    public static boolean isMaxFrameSizeValid(int maxFrameSize) {
        return maxFrameSize >= 16384 && maxFrameSize <= 0xFFFFFF;
    }

    public static ByteBuf connectionPrefaceBuf() {
        return CONNECTION_PREFACE.retainedDuplicate();
    }

    public static Http2Exception getEmbeddedHttp2Exception(Throwable cause) {
        while (cause != null) {
            if (cause instanceof Http2Exception) {
                return (Http2Exception)cause;
            }
            cause = cause.getCause();
        }
        return null;
    }

    public static ByteBuf toByteBuf(ChannelHandlerContext ctx, Throwable cause) {
        if (cause == null || cause.getMessage() == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        return ByteBufUtil.writeUtf8(ctx.alloc(), (CharSequence)cause.getMessage());
    }

    public static int readUnsignedInt(ByteBuf buf) {
        return buf.readInt() & Integer.MAX_VALUE;
    }

    public static int streamableBytes(StreamByteDistributor.StreamState state) {
        return Math.max(0, (int)Math.min(state.pendingBytes(), (long)state.windowSize()));
    }

    public static void headerListSizeExceeded(int streamId, long maxHeaderListSize, boolean onDecode) throws Http2Exception {
        throw Http2Exception.headerListSizeError(streamId, Http2Error.PROTOCOL_ERROR, onDecode, "Header size exceeded max allowed size (%d)", maxHeaderListSize);
    }

    public static void headerListSizeExceeded(long maxHeaderListSize) throws Http2Exception {
        throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size (%d)", maxHeaderListSize);
    }

    static void writeFrameHeaderInternal(ByteBuf out, int payloadLength, byte type, Http2Flags flags, int streamId) {
        out.writeMedium(payloadLength);
        out.writeByte(type);
        out.writeByte(flags.value());
        out.writeInt(streamId);
    }

    public static void verifyPadding(int padding) {
        if (padding < 0 || padding > 256) {
            throw new IllegalArgumentException(String.format("Invalid padding '%d'. Padding must be between 0 and %d (inclusive).", padding, 256));
        }
    }

    private Http2CodecUtil() {
    }

    static final class SimpleChannelPromiseAggregator
    extends DefaultChannelPromise {
        private final ChannelPromise promise;
        private int expectedCount;
        private int doneCount;
        private Throwable lastFailure;
        private boolean doneAllocating;

        SimpleChannelPromiseAggregator(ChannelPromise promise, Channel c, EventExecutor e) {
            super(c, e);
            assert (promise != null && !promise.isDone());
            this.promise = promise;
        }

        public ChannelPromise newPromise() {
            assert (!this.doneAllocating) : "Done allocating. No more promises can be allocated.";
            ++this.expectedCount;
            return this;
        }

        public ChannelPromise doneAllocatingPromises() {
            if (!this.doneAllocating) {
                this.doneAllocating = true;
                if (this.doneCount == this.expectedCount || this.expectedCount == 0) {
                    return this.setPromise();
                }
            }
            return this;
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.lastFailure = cause;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.lastFailure = cause;
                if (this.allPromisesDone()) {
                    return this.setPromise();
                }
            }
            return this;
        }

        @Override
        public ChannelPromise setSuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    this.setPromise();
                }
            }
            return this;
        }

        @Override
        public boolean trySuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        private boolean allowFailure() {
            return this.awaitingPromises() || this.expectedCount == 0;
        }

        private boolean awaitingPromises() {
            return this.doneCount < this.expectedCount;
        }

        private boolean allPromisesDone() {
            return this.doneCount == this.expectedCount && this.doneAllocating;
        }

        private ChannelPromise setPromise() {
            if (this.lastFailure == null) {
                this.promise.setSuccess();
                return super.setSuccess(null);
            }
            this.promise.setFailure(this.lastFailure);
            return super.setFailure(this.lastFailure);
        }

        private boolean tryPromise() {
            if (this.lastFailure == null) {
                this.promise.trySuccess();
                return super.trySuccess(null);
            }
            this.promise.tryFailure(this.lastFailure);
            return super.tryFailure(this.lastFailure);
        }
    }
}

