/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.AbstractServerStream;
import org.glowroot.agent.shaded.io.grpc.internal.TransportTracer;
import org.glowroot.agent.shaded.io.grpc.internal.WritableBuffer;
import org.glowroot.agent.shaded.io.grpc.netty.CancelServerStreamCommand;
import org.glowroot.agent.shaded.io.grpc.netty.NettyServerHandler;
import org.glowroot.agent.shaded.io.grpc.netty.NettyWritableBuffer;
import org.glowroot.agent.shaded.io.grpc.netty.SendGrpcFrameCommand;
import org.glowroot.agent.shaded.io.grpc.netty.StreamIdHolder;
import org.glowroot.agent.shaded.io.grpc.netty.WriteQueue;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBuf;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFuture;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFutureListener;
import org.glowroot.agent.shaded.io.netty.channel.EventLoop;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Stream;

class NettyServerStream
extends AbstractServerStream {
    private static final Logger log = Logger.getLogger(NettyServerStream.class.getName());
    private final Sink sink;
    private final TransportState state;
    private final Channel channel;
    private final WriteQueue writeQueue;
    private final TransportTracer transportTracer;

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    public static class TransportState
    extends AbstractServerStream.TransportState
    implements StreamIdHolder {
        private final Http2Stream http2Stream;
        private final NettyServerHandler handler;
        private final EventLoop eventLoop;

        @Override
        public void runOnTransportThread(Runnable r) {
            if (this.eventLoop.inEventLoop()) {
                r.run();
            } else {
                this.eventLoop.execute(r);
            }
        }

        @Override
        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        @Override
        public void deframeFailed(Throwable cause) {
            log.log(Level.WARNING, "Exception processing message", cause);
            Status status = Status.fromThrowable(cause);
            this.transportReportStatus(status);
            this.handler.getWriteQueue().enqueue(new CancelServerStreamCommand(this, status), true);
        }

        @Override
        public int id() {
            return this.http2Stream.id();
        }
    }

    private class Sink
    implements AbstractServerStream.Sink {
        final /* synthetic */ NettyServerStream this$0;

        @Override
        public void request(final int numMessages) {
            if (this.this$0.channel.eventLoop().inEventLoop()) {
                this.this$0.transportState().requestMessagesFromDeframer(numMessages);
            } else {
                this.this$0.channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        Sink.this.this$0.transportState().requestMessagesFromDeframer(numMessages);
                    }
                });
            }
        }

        @Override
        public void writeFrame(WritableBuffer frame, boolean flush, final int numMessages) {
            Preconditions.checkArgument(numMessages >= 0);
            if (frame == null) {
                this.this$0.writeQueue.scheduleFlush();
                return;
            }
            ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf();
            final int numBytes = bytebuf.readableBytes();
            this.this$0.onSendingBytes(numBytes);
            this.this$0.writeQueue.enqueue(new SendGrpcFrameCommand(this.this$0.transportState(), bytebuf, false), this.this$0.channel.newPromise().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    Sink.this.this$0.transportState().onSentBytes(numBytes);
                    if (future.isSuccess()) {
                        Sink.this.this$0.transportTracer.reportMessageSent(numMessages);
                    }
                }
            }), flush);
        }
    }
}

