/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.internal.AbstractReadableBuffer;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBuf;

class NettyReadableBuffer
extends AbstractReadableBuffer {
    private final ByteBuf buffer;
    private boolean closed;

    NettyReadableBuffer(ByteBuf buffer) {
        this.buffer = Preconditions.checkNotNull(buffer, "buffer");
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public void readBytes(byte[] dest, int index, int length) {
        this.buffer.readBytes(dest, index, length);
    }

    @Override
    public NettyReadableBuffer readBytes(int length) {
        return new NettyReadableBuffer(this.buffer.readRetainedSlice(length));
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.buffer.release();
        }
    }
}

