/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.agent.shaded.io.grpc.CallOptions;
import org.glowroot.agent.shaded.io.grpc.ClientStreamTracer;
import org.glowroot.agent.shaded.io.grpc.Metadata;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.StreamTracer;
import org.glowroot.agent.shaded.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StatsTraceContext {
    public static final StatsTraceContext NOOP = new StatsTraceContext(new StreamTracer[0]);
    private final StreamTracer[] tracers;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static StatsTraceContext newClientContext(CallOptions callOptions, Metadata headers) {
        List<ClientStreamTracer.Factory> factories = callOptions.getStreamTracerFactories();
        if (factories.isEmpty()) {
            return NOOP;
        }
        StreamTracer[] tracers = new StreamTracer[factories.size()];
        for (int i = 0; i < tracers.length; ++i) {
            tracers[i] = factories.get(i).newClientStreamTracer(callOptions, headers);
        }
        return new StatsTraceContext(tracers);
    }

    StatsTraceContext(StreamTracer[] tracers) {
        this.tracers = tracers;
    }

    public void clientOutboundHeaders() {
        for (StreamTracer tracer : this.tracers) {
            ((ClientStreamTracer)tracer).outboundHeaders();
        }
    }

    public void clientInboundHeaders() {
        for (StreamTracer tracer : this.tracers) {
            ((ClientStreamTracer)tracer).inboundHeaders();
        }
    }

    public void streamClosed(Status status) {
        if (this.closed.compareAndSet(false, true)) {
            for (StreamTracer tracer : this.tracers) {
                tracer.streamClosed(status);
            }
        }
    }

    public void outboundMessage(int seqNo) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundMessage(seqNo);
        }
    }

    public void inboundMessage(int seqNo) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundMessage(seqNo);
        }
    }

    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundMessageSent(seqNo, optionalWireSize, optionalUncompressedSize);
        }
    }

    public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundMessageRead(seqNo, optionalWireSize, optionalUncompressedSize);
        }
    }

    public void outboundUncompressedSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundUncompressedSize(bytes);
        }
    }

    public void outboundWireSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundWireSize(bytes);
        }
    }

    public void inboundUncompressedSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundUncompressedSize(bytes);
        }
    }

    public void inboundWireSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundWireSize(bytes);
        }
    }
}

