/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.KnownLength;
import org.glowroot.agent.shaded.io.grpc.internal.AbstractReadableBuffer;
import org.glowroot.agent.shaded.io.grpc.internal.ForwardingReadableBuffer;
import org.glowroot.agent.shaded.io.grpc.internal.ReadableBuffer;

public final class ReadableBuffers {
    private static final ReadableBuffer EMPTY_BUFFER = new ByteArrayWrapper(new byte[0]);

    public static ReadableBuffer wrap(byte[] bytes, int offset, int length) {
        return new ByteArrayWrapper(bytes, offset, length);
    }

    public static byte[] readArray(ReadableBuffer buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        int length = buffer.readableBytes();
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes, 0, length);
        return bytes;
    }

    public static String readAsString(ReadableBuffer buffer, Charset charset) {
        Preconditions.checkNotNull(charset, "charset");
        byte[] bytes = ReadableBuffers.readArray(buffer);
        return new String(bytes, charset);
    }

    public static InputStream openStream(ReadableBuffer buffer, boolean owner) {
        return new BufferInputStream(owner ? buffer : ReadableBuffers.ignoreClose(buffer));
    }

    public static ReadableBuffer ignoreClose(ReadableBuffer buffer) {
        return new ForwardingReadableBuffer(buffer){

            @Override
            public void close() {
            }
        };
    }

    private static final class BufferInputStream
    extends InputStream
    implements KnownLength {
        final ReadableBuffer buffer;

        public BufferInputStream(ReadableBuffer buffer) {
            this.buffer = Preconditions.checkNotNull(buffer, "buffer");
        }

        @Override
        public int available() throws IOException {
            return this.buffer.readableBytes();
        }

        @Override
        public int read() {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            return this.buffer.readUnsignedByte();
        }

        @Override
        public int read(byte[] dest, int destOffset, int length) throws IOException {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            length = Math.min(this.buffer.readableBytes(), length);
            this.buffer.readBytes(dest, destOffset, length);
            return length;
        }

        @Override
        public void close() throws IOException {
            this.buffer.close();
        }
    }

    private static class ByteArrayWrapper
    extends AbstractReadableBuffer {
        int offset;
        final int end;
        final byte[] bytes;

        ByteArrayWrapper(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        ByteArrayWrapper(byte[] bytes, int offset, int length) {
            Preconditions.checkArgument(offset >= 0, "offset must be >= 0");
            Preconditions.checkArgument(length >= 0, "length must be >= 0");
            Preconditions.checkArgument(offset + length <= bytes.length, "offset + length exceeds array boundary");
            this.bytes = Preconditions.checkNotNull(bytes, "bytes");
            this.offset = offset;
            this.end = offset + length;
        }

        @Override
        public int readableBytes() {
            return this.end - this.offset;
        }

        @Override
        public int readUnsignedByte() {
            this.checkReadable(1);
            return this.bytes[this.offset++] & 0xFF;
        }

        @Override
        public void readBytes(byte[] dest, int destIndex, int length) {
            System.arraycopy(this.bytes, this.offset, dest, destIndex, length);
            this.offset += length;
        }

        @Override
        public ByteArrayWrapper readBytes(int length) {
            this.checkReadable(length);
            int originalOffset = this.offset;
            this.offset += length;
            return new ByteArrayWrapper(this.bytes, originalOffset, length);
        }
    }
}

