/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.security.cert.Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.internal.Instrumented;
import org.glowroot.agent.shaded.io.grpc.internal.WithLogId;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;

public final class Channelz {
    private static final Logger log = Logger.getLogger(Channelz.class.getName());
    private static final Channelz INSTANCE = new Channelz();
    private final ConcurrentNavigableMap<Long, Instrumented<Object>> servers = new ConcurrentSkipListMap<Long, Instrumented<Object>>();
    private final ConcurrentNavigableMap<Long, Instrumented<Object>> rootChannels = new ConcurrentSkipListMap<Long, Instrumented<Object>>();
    private final ConcurrentMap<Long, Instrumented<Object>> subchannels = new ConcurrentHashMap<Long, Instrumented<Object>>();
    private final ConcurrentMap<Long, Instrumented<Object>> otherSockets = new ConcurrentHashMap<Long, Instrumented<Object>>();
    private final ConcurrentMap<Long, Object> perServerSockets = new ConcurrentHashMap<Long, Object>();

    public static Channelz instance() {
        return INSTANCE;
    }

    public void addSubchannel(Instrumented<Object> subchannel) {
        Channelz.add(this.subchannels, subchannel);
    }

    public void addRootChannel(Instrumented<Object> rootChannel) {
        Channelz.add(this.rootChannels, rootChannel);
    }

    public void addClientSocket(Instrumented<Object> socket) {
        Channelz.add(this.otherSockets, socket);
    }

    public void removeSubchannel(Instrumented<Object> subchannel) {
        Channelz.remove(this.subchannels, subchannel);
    }

    public void removeRootChannel(Instrumented<Object> channel) {
        Channelz.remove(this.rootChannels, channel);
    }

    public void removeClientSocket(Instrumented<Object> socket) {
        Channelz.remove(this.otherSockets, socket);
    }

    private static <T extends Instrumented<?>> void add(Map<Long, T> map, T object) {
        Instrumented prev = (Instrumented)map.put(object.getLogId().getId(), object);
        assert (prev == null);
    }

    private static <T extends Instrumented<?>> void remove(Map<Long, T> map, T object) {
        Instrumented prev = (Instrumented)map.remove(Channelz.id(object));
        assert (prev != null);
    }

    public static long id(WithLogId withLogId) {
        return withLogId.getLogId().getId();
    }

    @Immutable
    public static final class Tls {
        public final String cipherSuiteStandardName;
        @Nullable
        public final Certificate localCert;
        @Nullable
        public final Certificate remoteCert;

        public Tls(SSLSession session) {
            String cipherSuiteStandardName = session.getCipherSuite();
            Certificate localCert = null;
            Certificate remoteCert = null;
            Certificate[] localCerts = session.getLocalCertificates();
            if (localCerts != null) {
                localCert = localCerts[0];
            }
            try {
                Certificate[] peerCerts = session.getPeerCertificates();
                if (peerCerts != null) {
                    remoteCert = peerCerts[0];
                }
            }
            catch (SSLPeerUnverifiedException e) {
                log.log(Level.FINE, String.format("Peer cert not available for peerHost=%s", session.getPeerHost()), e);
            }
            this.cipherSuiteStandardName = cipherSuiteStandardName;
            this.localCert = localCert;
            this.remoteCert = remoteCert;
        }
    }

    public static final class OtherSecurity {
    }

    public static final class Security {
        @Nullable
        public final Tls tls;
        @Nullable
        public final OtherSecurity other;

        public Security(Tls tls) {
            this.tls = Preconditions.checkNotNull(tls);
            this.other = null;
        }
    }

    @Immutable
    public static final class ChannelTrace {

        @Immutable
        public static final class Event {
            public final String description;
            public final Severity severity;
            public final long timestampNanos;
            @Nullable
            public final WithLogId channelRef;
            @Nullable
            public final WithLogId subchannelRef;

            private Event(String description, Severity severity, long timestampNanos, @Nullable WithLogId channelRef, @Nullable WithLogId subchannelRef) {
                this.description = description;
                this.severity = Preconditions.checkNotNull(severity, "severity");
                this.timestampNanos = timestampNanos;
                this.channelRef = channelRef;
                this.subchannelRef = subchannelRef;
            }

            public int hashCode() {
                return Objects.hashCode(new Object[]{this.description, this.severity, this.timestampNanos, this.channelRef, this.subchannelRef});
            }

            public boolean equals(Object o) {
                if (o instanceof Event) {
                    Event that = (Event)o;
                    return Objects.equal(this.description, that.description) && Objects.equal((Object)this.severity, (Object)that.severity) && this.timestampNanos == that.timestampNanos && Objects.equal(this.channelRef, that.channelRef) && Objects.equal(this.subchannelRef, that.subchannelRef);
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("description", this.description).add("severity", (Object)this.severity).add("timestampNanos", this.timestampNanos).add("channelRef", this.channelRef).add("subchannelRef", this.subchannelRef).toString();
            }

            public static final class Builder {
                private String description;
                private Severity severity;
                private Long timestampNanos;
                private WithLogId channelRef;
                private WithLogId subchannelRef;

                public Builder setDescription(String description) {
                    this.description = description;
                    return this;
                }

                public Builder setTimestampNanos(long timestampNanos) {
                    this.timestampNanos = timestampNanos;
                    return this;
                }

                public Builder setSeverity(Severity severity) {
                    this.severity = severity;
                    return this;
                }

                public Builder setSubchannelRef(WithLogId subchannelRef) {
                    this.subchannelRef = subchannelRef;
                    return this;
                }

                public Event build() {
                    Preconditions.checkNotNull(this.description, "description");
                    Preconditions.checkNotNull(this.severity, "severity");
                    Preconditions.checkNotNull(this.timestampNanos, "timestampNanos");
                    Preconditions.checkState(this.channelRef == null || this.subchannelRef == null, "at least one of channelRef and subchannelRef must be null");
                    return new Event(this.description, this.severity, this.timestampNanos, this.channelRef, this.subchannelRef);
                }
            }

            public static enum Severity {
                CT_UNKNOWN,
                CT_INFO,
                CT_WARNING,
                CT_ERROR;

            }
        }
    }
}

