/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import java.util.concurrent.TimeoutException;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Context;
import org.glowroot.agent.shaded.io.grpc.Status;

public final class Contexts {
    public static Status statusFromCancelled(Context context) {
        Preconditions.checkNotNull(context, "context must not be null");
        if (!context.isCancelled()) {
            return null;
        }
        Throwable cancellationCause = context.cancellationCause();
        if (cancellationCause == null) {
            return Status.CANCELLED.withDescription("org.glowroot.agent.shaded.io.grpc.Context was cancelled without error");
        }
        if (cancellationCause instanceof TimeoutException) {
            return Status.DEADLINE_EXCEEDED.withDescription(cancellationCause.getMessage()).withCause(cancellationCause);
        }
        Status status = Status.fromThrowable(cancellationCause);
        if (Status.Code.UNKNOWN.equals((Object)status.getCode()) && status.getCause() == cancellationCause) {
            return Status.CANCELLED.withDescription("Context cancelled").withCause(cancellationCause);
        }
        return status.withCause(cancellationCause);
    }
}

