/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.protobuf;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import org.glowroot.agent.shaded.com.google.protobuf.CodedInputStream;
import org.glowroot.agent.shaded.com.google.protobuf.CodedOutputStream;
import org.glowroot.agent.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.glowroot.agent.shaded.com.google.protobuf.FieldSet;
import org.glowroot.agent.shaded.com.google.protobuf.MessageLite;
import org.glowroot.agent.shaded.com.google.protobuf.WireFormat;

public class MapEntryLite<K, V> {
    static <K, V> void writeTo(CodedOutputStream output, Metadata<K, V> metadata, K key, V value) throws IOException {
        FieldSet.writeElement(output, metadata.keyType, 1, key);
        FieldSet.writeElement(output, metadata.valueType, 2, value);
    }

    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K key, V value) {
        return FieldSet.computeElementSize(metadata.keyType, 1, key) + FieldSet.computeElementSize(metadata.valueType, 2, value);
    }

    static <T> T parseField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        switch (type) {
            case MESSAGE: {
                MessageLite.Builder subBuilder = ((MessageLite)value).toBuilder();
                input.readMessage(subBuilder, extensionRegistry);
                return (T)subBuilder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(input, type, true);
    }

    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream input, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        int tag;
        Object key = metadata.defaultKey;
        Object value = metadata.defaultValue;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                key = MapEntryLite.parseField(input, extensionRegistry, metadata.keyType, key);
                continue;
            }
            if (tag == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                value = MapEntryLite.parseField(input, extensionRegistry, metadata.valueType, value);
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        return new AbstractMap.SimpleImmutableEntry(key, value);
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        public Metadata(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
            this.keyType = keyType;
            this.defaultKey = defaultKey;
            this.valueType = valueType;
            this.defaultValue = defaultValue;
        }
    }
}

