/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonToken;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.agent.shaded.com.google.common.base.Optional;

public class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    protected final JavaType _fullType;
    protected final JavaType _referenceType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public GuavaOptionalDeserializer(JavaType fullType, JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._referenceType = refType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    @Override
    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    protected GuavaOptionalDeserializer withResolved(JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (refType == this._referenceType && valueDeser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new GuavaOptionalDeserializer(this._fullType, refType, typeDeser, valueDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        JavaType refType = this._referenceType;
        if (deser == null) {
            if (property != null) {
                Class<?> cc;
                AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
                AnnotatedMember member = property.getMember();
                if (intr != null && member != null && (cc = intr.findDeserializationContentType(member, refType)) != null && !refType.hasRawClass(cc)) {
                    refType = refType.narrowBy(cc);
                }
            }
            deser = ctxt.findContextualValueDeserializer(refType, property);
        } else {
            deser = ctxt.handleSecondaryContextualization(deser, property, refType);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(refType, typeDeser, deser);
    }

    @Override
    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jp, ctxt) : this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        return Optional.fromNullable(refd);
    }

    @Override
    public Optional<?> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue();
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(jp, ctxt);
        }
        return Optional.fromNullable(typeDeserializer.deserializeTypedFromAny(jp, ctxt));
    }
}

