/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonToken;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.BaseJsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ContainerNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.MissingNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.TextNode;

public class ObjectNode
extends ContainerNode<ObjectNode> {
    protected final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(String fieldName) {
        return this._children.get(fieldName);
    }

    @Override
    public JsonNode path(String fieldName) {
        JsonNode n = this._children.get(fieldName);
        if (n != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeStartObject();
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            jg.writeFieldName(en.getKey());
            ((BaseJsonNode)en.getValue()).serialize(jg, provider);
        }
        jg.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(this, jg);
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            jg.writeFieldName(en.getKey());
            ((BaseJsonNode)en.getValue()).serialize(jg, provider);
        }
        typeSer.writeTypeSuffixForObject(this, jg);
    }

    public JsonNode set(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._children.put(fieldName, value);
        return this;
    }

    public JsonNode replace(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(fieldName, value);
    }

    public JsonNode remove(String fieldName) {
        return this._children.remove(fieldName);
    }

    public ArrayNode putArray(String fieldName) {
        ArrayNode n = this.arrayNode();
        this._put(fieldName, n);
        return n;
    }

    public ObjectNode put(String fieldName, int v) {
        return this._put(fieldName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, String v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.textNode(v));
    }

    public ObjectNode put(String fieldName, boolean v) {
        return this._put(fieldName, this.booleanNode(v));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)o);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode other) {
        return this._children.equals(other._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32 + (this.size() << 4));
        sb.append("{");
        int count = 0;
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            if (count > 0) {
                sb.append(",");
            }
            ++count;
            TextNode.appendQuoted(sb, en.getKey());
            sb.append(':');
            sb.append(en.getValue().toString());
        }
        sb.append("}");
        return sb.toString();
    }

    protected ObjectNode _put(String fieldName, JsonNode value) {
        this._children.put(fieldName, value);
        return this;
    }
}

