/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.BigIntegerNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.BinaryNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.BooleanNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.DecimalNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.DoubleNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.IntNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.LongNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.NumericNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.POJONode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.TextNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ValueNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util.RawValue;

public class JsonNodeFactory
implements Serializable {
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bigDecimalExact) {
        this._cfgBigDecimalExact = bigDecimalExact;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public NumericNode numberNode(BigDecimal v) {
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(v);
        }
        return v.compareTo(BigDecimal.ZERO) == 0 ? DecimalNode.ZERO : DecimalNode.valueOf(v.stripTrailingZeros());
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public ValueNode pojoNode(Object pojo) {
        return new POJONode(pojo);
    }

    public ValueNode rawValueNode(RawValue value) {
        return new POJONode(value);
    }
}

