/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.core.io;

import java.io.Serializable;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.SerializableString;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.io.JsonStringEncoder;

public class SerializedString
implements Serializable,
SerializableString {
    protected final String _value;
    protected byte[] _quotedUTF8Ref;
    protected byte[] _unquotedUTF8Ref;
    protected char[] _quotedChars;

    public SerializedString(String v) {
        if (v == null) {
            throw new IllegalStateException("Null String illegal for SerializedString");
        }
        this._value = v;
    }

    @Override
    public final String getValue() {
        return this._value;
    }

    @Override
    public final char[] asQuotedChars() {
        char[] result = this._quotedChars;
        if (result == null) {
            this._quotedChars = result = JsonStringEncoder.getInstance().quoteAsString(this._value);
        }
        return result;
    }

    @Override
    public final byte[] asUnquotedUTF8() {
        byte[] result = this._unquotedUTF8Ref;
        if (result == null) {
            this._unquotedUTF8Ref = result = JsonStringEncoder.getInstance().encodeAsUTF8(this._value);
        }
        return result;
    }

    @Override
    public final byte[] asQuotedUTF8() {
        byte[] result = this._quotedUTF8Ref;
        if (result == null) {
            this._quotedUTF8Ref = result = JsonStringEncoder.getInstance().quoteAsUTF8(this._value);
        }
        return result;
    }

    @Override
    public int appendQuotedUTF8(byte[] buffer, int offset) {
        int length;
        byte[] result = this._quotedUTF8Ref;
        if (result == null) {
            this._quotedUTF8Ref = result = JsonStringEncoder.getInstance().quoteAsUTF8(this._value);
        }
        if (offset + (length = result.length) > buffer.length) {
            return -1;
        }
        System.arraycopy(result, 0, buffer, offset, length);
        return length;
    }

    public final String toString() {
        return this._value;
    }

    public final int hashCode() {
        return this._value.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SerializedString other = (SerializedString)o;
        return this._value.equals(other._value);
    }
}

